/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.OperationImpl;

abstract class BaseStoreOperationImpl
extends OperationImpl {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORED = new OperationStatus(true, "STORED", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private static final OperationStatus EXISTS = new OperationStatus(false, "EXISTS", StatusCode.ERR_EXISTS);
    protected final String type;
    protected final String key;
    protected final int flags;
    protected final int exp;
    protected final byte[] data;

    public BaseStoreOperationImpl(String t, String k, int f, int e, byte[] d, OperationCallback cb) {
        super(cb);
        this.type = t;
        this.key = k;
        this.flags = f;
        this.exp = e;
        this.data = d;
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, STORED, NOT_FOUND, EXISTS));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(bb, this.type, this.key, this.flags, this.exp, this.data.length);
        assert (bb.remaining() >= this.data.length + 2) : "Not enough room in buffer, need another " + (2 + this.data.length - bb.remaining());
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getExpiration() {
        return this.exp;
    }

    public byte[] getData() {
        return this.data;
    }
}

