/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.spy.memcached.collection.CollectionBulkInsert;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionBulkInsertOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionBulkInsertOperationImpl
extends OperationImpl
implements CollectionBulkInsertOperation {
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus FAILED_END = new CollectionOperationStatus(false, "END", CollectionResponse.END);
    private static final OperationStatus CREATED_STORED = new CollectionOperationStatus(true, "CREATED_STORED", CollectionResponse.CREATED_STORED);
    private static final OperationStatus STORED = new CollectionOperationStatus(true, "STORED", CollectionResponse.STORED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ELEMENT_EXISTS = new CollectionOperationStatus(false, "ELEMENT_EXISTS", CollectionResponse.ELEMENT_EXISTS);
    private static final OperationStatus OVERFLOWED = new CollectionOperationStatus(false, "OVERFLOWED", CollectionResponse.OVERFLOWED);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    protected final String key;
    protected final CollectionBulkInsert<?> insert;
    protected final CollectionBulkInsertOperation.Callback cb;
    protected int count;
    protected int index = 0;
    protected boolean successAll = true;

    public CollectionBulkInsertOperationImpl(List<String> keyList, CollectionBulkInsert<?> insert, OperationCallback cb) {
        super(cb);
        this.key = keyList.get(0);
        this.insert = insert;
        this.cb = (CollectionBulkInsertOperation.Callback)cb;
        if (this.insert instanceof CollectionBulkInsert.ListBulkInsert) {
            this.setAPIType(APIType.LOP_INSERT);
        } else if (this.insert instanceof CollectionBulkInsert.SetBulkInsert) {
            this.setAPIType(APIType.SOP_INSERT);
        } else if (this.insert instanceof CollectionBulkInsert.MapBulkInsert) {
            this.setAPIType(APIType.MOP_INSERT);
        } else if (this.insert instanceof CollectionBulkInsert.BTreeBulkInsert) {
            this.setAPIType(APIType.BOP_INSERT);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.insert.setNextOpIndex(this.index);
            this.receivedMoveOperations(line);
            return;
        }
        if (this.insert.getItemCount() == 1) {
            OperationStatus status = this.matchStatus(line, STORED, CREATED_STORED, NOT_FOUND, ELEMENT_EXISTS, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH);
            if (status.isSuccess()) {
                this.cb.receivedStatus(END);
            } else {
                this.cb.gotStatus(this.index, status);
                this.cb.receivedStatus(FAILED_END);
            }
            this.transitionState(OperationState.COMPLETE);
            return;
        }
        if (line.startsWith("END") || line.startsWith("PIPE_ERROR ")) {
            this.cb.receivedStatus(this.successAll ? END : FAILED_END);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("RESPONSE ")) {
            this.getLogger().debug("Got line %s", line);
            line = line.replace("   ", " ");
            line = line.replace("  ", " ");
            String[] stuff = line.split(" ");
            assert ("RESPONSE".equals(stuff[0]));
            this.count = Integer.parseInt(stuff[1]);
        } else {
            OperationStatus status = this.matchStatus(line, STORED, CREATED_STORED, NOT_FOUND, ELEMENT_EXISTS, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH);
            if (!status.isSuccess()) {
                this.cb.gotStatus(this.index, status);
                this.successAll = false;
            }
            ++this.index;
        }
    }

    @Override
    public void initialize() {
        ByteBuffer buffer = this.insert.getAsciiCommand();
        this.setBuffer(buffer);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: \n" + new String(buffer.array()).replaceAll("\\r\\n", "\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionBulkInsert<?> getInsert() {
        return this.insert;
    }
}

