/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeCreate;
import net.spy.memcached.collection.CollectionCreate;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.ListCreate;
import net.spy.memcached.collection.MapCreate;
import net.spy.memcached.collection.SetCreate;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionCreateOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionCreateOperationImpl
extends OperationImpl
implements CollectionCreateOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus CREATED = new CollectionOperationStatus(true, "CREATED", CollectionResponse.CREATED);
    private static final OperationStatus EXISTS = new CollectionOperationStatus(false, "EXISTS", CollectionResponse.EXISTS);
    private static final OperationStatus SERVER_ERROR = new CollectionOperationStatus(false, "SERVER_ERROR", CollectionResponse.SERVER_ERROR);
    protected final String key;
    protected final CollectionCreate collectionCreate;

    public CollectionCreateOperationImpl(String key, CollectionCreate collectionCreate, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.collectionCreate = collectionCreate;
        if (this.collectionCreate instanceof ListCreate) {
            this.setAPIType(APIType.LOP_CREATE);
        } else if (this.collectionCreate instanceof SetCreate) {
            this.setAPIType(APIType.SOP_CREATE);
        } else if (this.collectionCreate instanceof BTreeCreate) {
            this.setAPIType(APIType.BOP_CREATE);
        } else if (this.collectionCreate instanceof MapCreate) {
            this.setAPIType(APIType.MOP_CREATE);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, CREATED, EXISTS, SERVER_ERROR));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String args = this.collectionCreate.stringify();
        ByteBuffer bb = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + args.length() + 32);
        this.setArguments(bb, this.collectionCreate.getCommand(), this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replaceAll("\\r\\n", ""));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionCreate getCreate() {
        return this.collectionCreate;
    }
}

