/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeDelete;
import net.spy.memcached.collection.CollectionDelete;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.ListDelete;
import net.spy.memcached.collection.MapDelete;
import net.spy.memcached.collection.SetDelete;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionDeleteOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionDeleteOperationImpl
extends OperationImpl
implements CollectionDeleteOperation {
    private static final OperationStatus DELETE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus DELETED = new CollectionOperationStatus(true, "DELETED", CollectionResponse.DELETED);
    private static final OperationStatus DELETED_DROPPED = new CollectionOperationStatus(true, "DELETED_DROPPED", CollectionResponse.DELETED_DROPPED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    protected String key;
    protected CollectionDelete collectionDelete;

    public CollectionDeleteOperationImpl(String key, CollectionDelete collectionDelete, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.collectionDelete = collectionDelete;
        if (this.collectionDelete instanceof ListDelete) {
            this.setAPIType(APIType.LOP_DELETE);
        } else if (this.collectionDelete instanceof SetDelete) {
            this.setAPIType(APIType.SOP_DELETE);
        } else if (this.collectionDelete instanceof MapDelete) {
            this.setAPIType(APIType.MOP_DELETE);
        } else if (this.collectionDelete instanceof BTreeDelete) {
            this.setAPIType(APIType.BOP_DELETE);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        OperationStatus status = this.matchStatus(line, DELETED, DELETED_DROPPED, NOT_FOUND, NOT_FOUND_ELEMENT, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH);
        this.getCallback().receivedStatus(status);
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String cmd = this.collectionDelete.getCommand();
        if (this.collectionDelete instanceof MapDelete) {
            MapDelete mapDelete = (MapDelete)this.collectionDelete;
            if (this.getHandlingNode() == null || this.getHandlingNode().enabledSpaceSeparate()) {
                mapDelete.setKeySeparator(" ");
            } else {
                mapDelete.setKeySeparator(",");
            }
        }
        String args = this.collectionDelete.stringify();
        byte[] additionalArgs = this.collectionDelete.getAdditionalArgs();
        ByteBuffer bb = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + cmd.length() + args.length() + (null == additionalArgs ? 0 : additionalArgs.length) + 16);
        this.setArguments(bb, cmd, this.key, args);
        if (null != additionalArgs) {
            bb.put(additionalArgs);
            bb.put(CRLF);
        }
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(DELETE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionDelete getDelete() {
        return this.collectionDelete;
    }
}

