/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionExist;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.SetExist;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionExistOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionExistOperationImpl
extends OperationImpl
implements CollectionExistOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus EXIST_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus EXIST = new CollectionOperationStatus(true, "EXIST", CollectionResponse.EXIST);
    private static final OperationStatus NOT_EXIST = new CollectionOperationStatus(true, "NOT_EXIST", CollectionResponse.NOT_EXIST);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    protected final String key;
    protected final String subkey;
    protected final CollectionExist collectionExist;

    public CollectionExistOperationImpl(String key, String subkey, CollectionExist collectionExist, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.subkey = subkey;
        this.collectionExist = collectionExist;
        if (this.collectionExist instanceof SetExist) {
            this.setAPIType(APIType.SOP_EXIST);
        }
        this.setOperationType(OperationType.READ);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        this.getCallback().receivedStatus(this.matchStatus(line, EXIST, NOT_EXIST, NOT_FOUND, NOT_FOUND, TYPE_MISMATCH, UNREADABLE));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String args = this.collectionExist.stringify();
        byte[] additionalArgs = this.collectionExist.getAdditionalArgs();
        ByteBuffer bb = ByteBuffer.allocate(null == additionalArgs ? 0 : additionalArgs.length + KeyUtil.getKeyBytes(this.key).length + KeyUtil.getKeyBytes(this.subkey).length + args.length() + 32);
        this.setArguments(bb, this.collectionExist.getCommand(), this.key, this.subkey, null == additionalArgs ? 0 : additionalArgs.length, args);
        if (null != additionalArgs) {
            bb.put(additionalArgs);
            bb.put(CRLF);
        }
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replaceAll("\\r\\n", ""));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(EXIST_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public String getSubKey() {
        return this.subkey;
    }

    @Override
    public CollectionExist getExist() {
        return this.collectionExist;
    }
}

