/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeInsert;
import net.spy.memcached.collection.BTreeUpsert;
import net.spy.memcached.collection.CollectionInsert;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.ListInsert;
import net.spy.memcached.collection.MapInsert;
import net.spy.memcached.collection.SetInsert;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionInsertOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionInsertOperationImpl
extends OperationImpl
implements CollectionInsertOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus CREATED_STORED = new CollectionOperationStatus(true, "CREATED_STORED", CollectionResponse.CREATED_STORED);
    private static final OperationStatus STORED = new CollectionOperationStatus(true, "STORED", CollectionResponse.STORED);
    private static final OperationStatus REPLACED = new CollectionOperationStatus(true, "REPLACED", CollectionResponse.REPLACED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ELEMENT_EXISTS = new CollectionOperationStatus(false, "ELEMENT_EXISTS", CollectionResponse.ELEMENT_EXISTS);
    private static final OperationStatus OVERFLOWED = new CollectionOperationStatus(false, "OVERFLOWED", CollectionResponse.OVERFLOWED);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    protected final String key;
    protected final String subkey;
    protected final CollectionInsert<?> collectionInsert;
    protected final byte[] data;

    public CollectionInsertOperationImpl(String key, String subkey, CollectionInsert<?> collectionInsert, byte[] data, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.subkey = subkey;
        this.collectionInsert = collectionInsert;
        this.data = data;
        if (this.collectionInsert instanceof ListInsert) {
            this.setAPIType(APIType.LOP_INSERT);
        } else if (this.collectionInsert instanceof SetInsert) {
            this.setAPIType(APIType.SOP_INSERT);
        } else if (this.collectionInsert instanceof MapInsert) {
            this.setAPIType(APIType.MOP_INSERT);
        } else if (this.collectionInsert instanceof BTreeInsert) {
            this.setAPIType(APIType.BOP_INSERT);
        } else if (this.collectionInsert instanceof BTreeUpsert) {
            this.setAPIType(APIType.BOP_UPSERT);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, STORED, REPLACED, CREATED_STORED, NOT_FOUND, ELEMENT_EXISTS, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String args = this.collectionInsert.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.key).length + KeyUtil.getKeyBytes(this.subkey).length + KeyUtil.getKeyBytes(this.collectionInsert.getElementFlagByHex()).length + args.length() + 32);
        this.setArguments(bb, this.collectionInsert.getCommand(), this.key, this.subkey, this.collectionInsert.getElementFlagByHex(), this.data.length, args);
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public String getSubKey() {
        return this.subkey;
    }

    @Override
    public CollectionInsert<?> getInsert() {
        return this.collectionInsert;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

