/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.SetPipedExist;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.CollectionPipedExistOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionPipedExistOperationImpl
extends OperationImpl
implements CollectionPipedExistOperation {
    private static final OperationStatus EXIST_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus EXIST = new CollectionOperationStatus(true, "EXIST", CollectionResponse.EXIST);
    private static final OperationStatus NOT_EXIST = new CollectionOperationStatus(true, "NOT_EXIST", CollectionResponse.NOT_EXIST);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus FAILED_END = new CollectionOperationStatus(false, "END", CollectionResponse.END);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    protected final String key;
    protected final SetPipedExist<?> setPipedExist;
    protected final CollectionPipedExistOperation.Callback cb;
    protected int count;
    protected int index = 0;
    protected boolean successAll = true;

    public CollectionPipedExistOperationImpl(String key, SetPipedExist<?> collectionExist, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.setPipedExist = collectionExist;
        this.cb = (CollectionPipedExistOperation.Callback)cb;
        if (this.setPipedExist instanceof SetPipedExist) {
            this.setAPIType(APIType.SOP_EXIST);
        }
        this.setOperationType(OperationType.READ);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (this.setPipedExist.getItemCount() == 1) {
            OperationStatus status = this.matchStatus(line, EXIST, NOT_EXIST, NOT_FOUND, TYPE_MISMATCH, UNREADABLE);
            this.cb.gotStatus(this.index, status);
            this.cb.receivedStatus(status.isSuccess() ? END : FAILED_END);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
        if (line.startsWith("END") || line.startsWith("PIPE_ERROR ")) {
            this.cb.receivedStatus(this.successAll ? END : FAILED_END);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("RESPONSE ")) {
            this.getLogger().debug("Got line %s", line);
            line = line.replace("   ", " ");
            line = line.replace("  ", " ");
            String[] stuff = line.split(" ");
            assert ("RESPONSE".equals(stuff[0]));
            this.count = Integer.parseInt(stuff[1]);
        } else {
            OperationStatus status = this.matchStatus(line, EXIST, NOT_EXIST, NOT_FOUND, TYPE_MISMATCH, UNREADABLE);
            if (!status.isSuccess()) {
                this.successAll = false;
            }
            this.cb.gotStatus(this.index, status);
            ++this.index;
        }
    }

    @Override
    public void initialize() {
        ByteBuffer buffer = this.setPipedExist.getAsciiCommand();
        this.setBuffer(buffer);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: \n" + new String(buffer.array()).replaceAll("\\r\\n", "\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(EXIST_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public SetPipedExist<?> getExist() {
        return this.setPipedExist;
    }
}

