/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionPipedUpdate;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.CollectionPipedUpdateOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionPipedUpdateOperationImpl
extends OperationImpl
implements CollectionPipedUpdateOperation {
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus FAILED_END = new CollectionOperationStatus(false, "END", CollectionResponse.END);
    private static final OperationStatus UPDATED = new CollectionOperationStatus(true, "UPDATED", CollectionResponse.UPDATED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus NOTHING_TO_UPDATE = new CollectionOperationStatus(false, "NOTHING_TO_UPDATE", CollectionResponse.NOTHING_TO_UPDATE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus EFLAG_MISMATCH = new CollectionOperationStatus(false, "EFLAG_MISMATCH", CollectionResponse.EFLAG_MISMATCH);
    private static final OperationStatus SERVER_ERROR = new CollectionOperationStatus(false, "SERVER_ERROR", CollectionResponse.SERVER_ERROR);
    protected final String key;
    protected final CollectionPipedUpdate<?> update;
    protected final CollectionPipedUpdateOperation.Callback cb;
    protected int count;
    protected int index = 0;
    protected boolean successAll = true;

    public CollectionPipedUpdateOperationImpl(String key, CollectionPipedUpdate<?> update, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.update = update;
        this.cb = (CollectionPipedUpdateOperation.Callback)cb;
        if (this.update instanceof CollectionPipedUpdate.BTreePipedUpdate) {
            this.setAPIType(APIType.BOP_UPDATE);
        } else if (this.update instanceof CollectionPipedUpdate.MapPipedUpdate) {
            this.setAPIType(APIType.MOP_UPDATE);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.update.setNextOpIndex(this.index);
            this.receivedMoveOperations(line);
            return;
        }
        if (this.update.getItemCount() == 1) {
            OperationStatus status = this.matchStatus(line, UPDATED, NOT_FOUND, NOT_FOUND_ELEMENT, NOTHING_TO_UPDATE, TYPE_MISMATCH, BKEY_MISMATCH, EFLAG_MISMATCH, SERVER_ERROR);
            if (status.isSuccess()) {
                this.cb.receivedStatus(END);
            } else {
                this.cb.gotStatus(this.index, status);
                this.cb.receivedStatus(FAILED_END);
            }
            this.transitionState(OperationState.COMPLETE);
            return;
        }
        if (line.startsWith("END") || line.startsWith("PIPE_ERROR ")) {
            this.cb.receivedStatus(this.successAll ? END : FAILED_END);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("RESPONSE ")) {
            this.getLogger().debug("Got line %s", line);
            line = line.replace("   ", " ");
            line = line.replace("  ", " ");
            String[] stuff = line.split(" ");
            assert ("RESPONSE".equals(stuff[0]));
            this.count = Integer.parseInt(stuff[1]);
        } else {
            OperationStatus status = this.matchStatus(line, UPDATED, NOT_FOUND, NOT_FOUND_ELEMENT, NOTHING_TO_UPDATE, TYPE_MISMATCH, BKEY_MISMATCH, EFLAG_MISMATCH, SERVER_ERROR);
            if (!status.isSuccess()) {
                this.cb.gotStatus(this.index, status);
                this.successAll = false;
            }
            ++this.index;
        }
    }

    @Override
    public void initialize() {
        ByteBuffer buffer = this.update.getAsciiCommand();
        this.setBuffer(buffer);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: \n" + new String(buffer.array()).replaceAll("\\r\\n", "\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionPipedUpdate<?> getUpdate() {
        return this.update;
    }
}

