/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeUpdate;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.CollectionUpdate;
import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.collection.MapUpdate;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.CollectionUpdateOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionUpdateOperationImpl
extends OperationImpl
implements CollectionUpdateOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus UPDATED = new CollectionOperationStatus(true, "UPDATED", CollectionResponse.UPDATED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus NOTHING_TO_UPDATE = new CollectionOperationStatus(false, "NOTHING_TO_UPDATE", CollectionResponse.NOTHING_TO_UPDATE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus EFLAG_MISMATCH = new CollectionOperationStatus(false, "EFLAG_MISMATCH", CollectionResponse.EFLAG_MISMATCH);
    private static final OperationStatus SERVER_ERROR = new CollectionOperationStatus(false, "SERVER_ERROR", CollectionResponse.SERVER_ERROR);
    protected final String key;
    protected final String subkey;
    protected final CollectionUpdate<?> collectionUpdate;
    protected final byte[] data;

    public CollectionUpdateOperationImpl(String key, String subkey, CollectionUpdate<?> collectionUpdate, byte[] data, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.subkey = subkey;
        this.collectionUpdate = collectionUpdate;
        this.data = data;
        if (this.collectionUpdate instanceof BTreeUpdate) {
            this.setAPIType(APIType.BOP_UPDATE);
        } else if (this.collectionUpdate instanceof MapUpdate) {
            this.setAPIType(APIType.MOP_UPDATE);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, UPDATED, NOT_FOUND, NOT_FOUND_ELEMENT, NOTHING_TO_UPDATE, TYPE_MISMATCH, BKEY_MISMATCH, EFLAG_MISMATCH, SERVER_ERROR));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String args = this.collectionUpdate.stringify();
        StringBuilder b = new StringBuilder();
        ElementFlagUpdate eflagUpdate = this.collectionUpdate.getElementFlagUpdate();
        if (eflagUpdate != null) {
            if (eflagUpdate.getElementFlagOffset() > -1 && eflagUpdate.getBitOp() != null) {
                b.append(eflagUpdate.getElementFlagOffset()).append(" ");
                b.append((Object)eflagUpdate.getBitOp()).append(" ");
            }
            b.append(eflagUpdate.getElementFlagByHex());
        }
        String eflagStr = b.toString();
        ByteBuffer bb = ByteBuffer.allocate((this.data != null ? this.data.length : 0) + KeyUtil.getKeyBytes(this.key).length + KeyUtil.getKeyBytes(this.subkey).length + eflagStr.length() + args.length() + 32);
        this.setArguments(bb, this.collectionUpdate.getCommand(), this.key, this.subkey, eflagStr, this.data != null ? Integer.valueOf(this.data.length) : "-1", args);
        if (this.data != null) {
            bb.put(this.data);
            bb.put(CRLF);
        }
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: '" + new String(bb.array()).replaceAll("\\r\\n", "\r\n") + "'");
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public String getSubKey() {
        return this.subkey;
    }

    @Override
    public CollectionUpdate<?> getUpdate() {
        return this.collectionUpdate;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

