/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class DeleteOperationImpl
extends OperationImpl
implements DeleteOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus DELETED = new OperationStatus(true, "DELETED", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private final String key;

    public DeleteOperationImpl(String k, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.setAPIType(APIType.DELETE);
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Delete of %s returned %s", this.key, line);
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, DELETED, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(b, "delete", this.key);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

