/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.GetAttrOperation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;

class GetAttrOperationImpl
extends OperationImpl
implements GetAttrOperation {
    private static final String CMD = "getattr";
    private static final OperationStatus ATTR_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ATTR_ERROR_NOT_FOUND = new CollectionOperationStatus(false, "ATTR_ERROR not found", CollectionResponse.ATTR_ERROR_NOT_FOUND);
    protected final String key;
    protected final GetAttrOperation.Callback cb;

    public GetAttrOperationImpl(String key, GetAttrOperation.Callback cb) {
        super(cb);
        this.key = key;
        this.cb = cb;
        this.setAPIType(APIType.GETATTR);
        this.setOperationType(OperationType.READ);
    }

    @Override
    public void handleLine(String line) {
        if (line.startsWith("ATTR ")) {
            this.getLogger().debug("Got line %s", line);
            String[] stuff = line.split(" ");
            assert (stuff.length == 2);
            assert (stuff[0].equals("ATTR"));
            this.cb.gotAttribute(this.key, stuff[1]);
        } else {
            OperationStatus status = this.matchStatus(line, END, NOT_FOUND, ATTR_ERROR_NOT_FOUND);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(status);
            }
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    @Override
    public void initialize() {
        int size = CMD.length() + KeyUtil.getKeyBytes(this.key).length + 16;
        ByteBuffer bb = ByteBuffer.allocate(size);
        this.setArguments(bb, CMD, this.key);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(ATTR_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

