/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class MutatorOperationImpl
extends OperationImpl
implements MutatorOperation {
    public static final int OVERHEAD = 32;
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private static final OperationStatus TYPE_MISMATCH = new OperationStatus(false, "TYPE_MISMATCH", StatusCode.ERR_TYPE_MISMATCH);
    private final Mutator mutator;
    private final String key;
    private final int amount;
    private final long def;
    private final int exp;

    public MutatorOperationImpl(Mutator m, String k, int amt, long d, int e, OperationCallback c) {
        super(c);
        this.mutator = m;
        this.key = k;
        this.amount = amt;
        this.def = d;
        this.exp = e;
        if (m == Mutator.incr) {
            this.setAPIType(APIType.INCR);
        } else if (m == Mutator.decr) {
            this.setAPIType(APIType.DECR);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        OperationStatus status = null;
        try {
            Long.valueOf(line);
            this.getCallback().receivedStatus(new OperationStatus(true, line));
        }
        catch (NumberFormatException e) {
            status = this.matchStatus(line, NOT_FOUND, TYPE_MISMATCH);
            this.getCallback().receivedStatus(status);
        }
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        int size = KeyUtil.getKeyBytes(this.key).length + 32;
        ByteBuffer b = ByteBuffer.allocate(size);
        if (this.def > -1L) {
            this.setArguments(b, this.mutator.name(), this.key, this.amount, 0, this.exp, this.def);
        } else {
            this.setArguments(b, this.mutator.name(), this.key, this.amount);
        }
        b.flip();
        this.setBuffer(b);
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public int getBy() {
        return this.amount;
    }

    @Override
    public long getDefault() {
        return -1L;
    }

    @Override
    public int getExpiration() {
        return -1;
    }

    @Override
    public Mutator getType() {
        return this.mutator;
    }
}

