/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.Attributes;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.ops.SetAttrOperation;
import net.spy.memcached.protocol.ascii.OperationImpl;

class SetAttrOperationImpl
extends OperationImpl
implements SetAttrOperation {
    private static final int OVERHEAD = 64;
    private static final OperationStatus ATTR_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus OK = new CollectionOperationStatus(true, "OK", CollectionResponse.OK);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ATTR_ERROR_NOT_FOUND = new CollectionOperationStatus(false, "ATTR_ERROR not found", CollectionResponse.ATTR_ERROR_NOT_FOUND);
    private static final OperationStatus ATTR_ERROR_BAD_VALUE = new CollectionOperationStatus(false, "ATTR_ERROR bad value", CollectionResponse.ATTR_ERROR_BAD_VALUE);
    protected final String key;
    protected final Attributes attrs;

    public SetAttrOperationImpl(String key, Attributes attrs, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.attrs = attrs == null ? new CollectionAttributes() : attrs;
        this.setAPIType(APIType.SETATTR);
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        this.getCallback().receivedStatus(this.matchStatus(line, OK, NOT_FOUND, ATTR_ERROR_NOT_FOUND, ATTR_ERROR_BAD_VALUE));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + this.attrs.getLength() + 64);
        this.setArguments(bb, "setattr", this.key, this.attrs);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(ATTR_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public Attributes getAttributes() {
        return this.attrs;
    }
}

