/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.CASResponse;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.CASOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.BaseOperationImpl;

abstract class OperationImpl
extends BaseOperationImpl {
    protected static final byte REQ_MAGIC = -128;
    protected static final byte RES_MAGIC = -127;
    protected static final int MIN_RECV_PACKET = 24;
    protected static final int ERR_NOT_FOUND = 1;
    protected static final int ERR_EXISTS = 2;
    protected static final int ERR_EINVAL = 4;
    protected static final int ERR_NOT_STORED = 5;
    protected static final OperationStatus NOT_FOUND_STATUS = new CASOperationStatus(false, "Not Found", CASResponse.NOT_FOUND, StatusCode.ERR_NOT_FOUND);
    protected static final OperationStatus EXISTS_STATUS = new CASOperationStatus(false, "Object exists", CASResponse.EXISTS, StatusCode.ERR_EXISTS);
    protected static final OperationStatus NOT_STORED_STATUS = new CASOperationStatus(false, "Not Stored", CASResponse.NOT_FOUND, StatusCode.ERR_NOT_STORED);
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected static final OperationStatus STATUS_OK = new CASOperationStatus(true, "OK", CASResponse.OK, StatusCode.SUCCESS);
    private static final AtomicInteger seqNumber = new AtomicInteger(0);
    private final int cmd;
    protected final int opaque;
    private final byte[] header = new byte[24];
    private int headerOffset = 0;
    private byte[] payload = null;
    protected int keyLen;
    protected int responseCmd;
    protected int errorCode;
    protected int responseOpaque;
    protected long responseCas;
    private int payloadOffset = 0;

    protected OperationImpl(int c, int o, OperationCallback cb) {
        this.cmd = c;
        this.opaque = o;
        this.setCallback(cb);
    }

    protected void resetInput() {
        this.payload = null;
        this.payloadOffset = 0;
        this.headerOffset = 0;
    }

    @Override
    public void readFromBuffer(ByteBuffer b) throws IOException {
        int available;
        int toRead;
        if (this.headerOffset < 24) {
            toRead = 24 - this.headerOffset;
            available = b.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d header bytes", toRead);
            b.get(this.header, this.headerOffset, toRead);
            this.headerOffset += toRead;
            if (this.headerOffset == 24) {
                byte magic = this.header[0];
                assert (magic == -127) : "Invalid magic:  " + magic;
                this.responseCmd = this.header[1];
                assert (this.cmd == -1 || this.responseCmd == this.cmd) : "Unexpected response command value";
                this.keyLen = OperationImpl.decodeShort(this.header, 2);
                this.errorCode = OperationImpl.decodeShort(this.header, 6);
                int bytesToRead = OperationImpl.decodeInt(this.header, 8);
                this.payload = new byte[bytesToRead];
                this.responseOpaque = OperationImpl.decodeInt(this.header, 12);
                this.responseCas = OperationImpl.decodeLong(this.header, 16);
                assert (this.opaqueIsValid()) : "Opaque is not valid";
            }
        }
        if (this.headerOffset >= 24 && this.payload == null) {
            this.finishedPayload(EMPTY_BYTES);
        } else if (this.payload != null) {
            toRead = this.payload.length - this.payloadOffset;
            available = b.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d payload bytes", toRead);
            b.get(this.payload, this.payloadOffset, toRead);
            this.payloadOffset += toRead;
            if (this.payloadOffset == this.payload.length) {
                this.finishedPayload(this.payload);
            }
        } else {
            this.getLogger().debug("Only read %d of the %d needed to fill a header", this.headerOffset, 24);
        }
    }

    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.errorCode != 0) {
            OperationStatus status = this.getStatusForErrorCode(this.errorCode, pl);
            if (status == null) {
                this.handleError(OperationErrorType.SERVER, new String(pl));
            } else {
                this.getCallback().receivedStatus(status);
                this.transitionState(OperationState.COMPLETE);
            }
        } else {
            this.decodePayload(pl);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        return null;
    }

    protected void decodePayload(byte[] pl) {
        assert (pl.length == 0) : "Payload has bytes, but decode isn't overridden";
        this.getCallback().receivedStatus(STATUS_OK);
    }

    protected boolean opaqueIsValid() {
        if (this.responseOpaque != this.opaque) {
            this.getLogger().warn("Expected opaque:  %d, got opaque:  %d\n", this.responseOpaque, this.opaque);
        }
        return this.responseOpaque == this.opaque;
    }

    static int decodeShort(byte[] data, int i) {
        return (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
    }

    static int decodeInt(byte[] data, int i) {
        return (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
    }

    static long decodeUnsignedInt(byte[] data, int i) {
        return (long)(data[i] & 0xFF) << 24 | (long)((data[i + 1] & 0xFF) << 16) | (long)((data[i + 2] & 0xFF) << 8) | (long)(data[i + 3] & 0xFF);
    }

    static long decodeLong(byte[] data, int i) {
        return (data[i] & 0xFF) << 56 | (data[i + 1] & 0xFF) << 48 | (data[i + 2] & 0xFF) << 40 | (data[i + 3] & 0xFF) << 32 | (data[i + 4] & 0xFF) << 24 | (data[i + 5] & 0xFF) << 16 | (data[i + 6] & 0xFF) << 8 | data[i + 7] & 0xFF;
    }

    protected void prepareBuffer(String key, long cas, byte[] val, Object ... extraHeaders) {
        int extraLen = 0;
        for (Object o : extraHeaders) {
            if (o instanceof Integer) {
                extraLen += 4;
                continue;
            }
            if (o instanceof byte[]) {
                extraLen += ((byte[])o).length;
                continue;
            }
            if (o instanceof Long) {
                extraLen += 8;
                continue;
            }
            assert (false) : "Unhandled extra header type:  " + o.getClass();
        }
        byte[] keyBytes = KeyUtil.getKeyBytes(key);
        int bufSize = 24 + keyBytes.length + val.length;
        ByteBuffer bb = ByteBuffer.allocate(bufSize + extraLen);
        assert (bb.order() == ByteOrder.BIG_ENDIAN);
        bb.put((byte)-128);
        bb.put((byte)this.cmd);
        bb.putShort((short)keyBytes.length);
        bb.put((byte)extraLen);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putInt(keyBytes.length + val.length + extraLen);
        bb.putInt(this.opaque);
        bb.putLong(cas);
        for (Object o : extraHeaders) {
            if (o instanceof Integer) {
                bb.putInt((Integer)o);
                continue;
            }
            if (o instanceof byte[]) {
                bb.put((byte[])o);
                continue;
            }
            if (o instanceof Long) {
                bb.putLong((Long)o);
                continue;
            }
            assert (false) : "Unhandled extra header type:  " + o.getClass();
        }
        bb.put(keyBytes);
        bb.put(val);
        bb.flip();
        this.setBuffer(bb);
    }

    static int generateOpaque() {
        int rv = seqNumber.incrementAndGet();
        while (rv < 0) {
            seqNumber.compareAndSet(rv, 0);
            rv = seqNumber.incrementAndGet();
        }
        return rv;
    }
}

