/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import java.util.Date;
import net.spy.memcached.CachedData;
import net.spy.memcached.collection.ElementValueType;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public class CollectionTranscoder
extends SerializingTranscoder
implements Transcoder<Object> {
    public static final int MAX_ELEMENT_BYTES = 32768;

    public CollectionTranscoder() {
        this(32768);
    }

    public CollectionTranscoder(int max) {
        super(max);
    }

    public static int examineFlags(ElementValueType type) {
        int flags = 0;
        if (type != ElementValueType.STRING) {
            flags = type == ElementValueType.LONG ? (flags |= 0x300) : (type == ElementValueType.INTEGER ? (flags |= 0x200) : (type == ElementValueType.BOOLEAN ? (flags |= 0x100) : (type == ElementValueType.DATE ? (flags |= 0x400) : (type == ElementValueType.BYTE ? (flags |= 0x500) : (type == ElementValueType.FLOAT ? (flags |= 0x600) : (type == ElementValueType.DOUBLE ? (flags |= 0x700) : (type == ElementValueType.BYTEARRAY ? (flags |= 0x800) : (flags |= 1))))))));
        }
        return flags;
    }

    @Override
    public Object decode(CachedData d) {
        byte[] data = d.getData();
        Object rv = null;
        int flags = d.getFlags() & 0xFF00;
        if ((d.getFlags() & 1) != 0 && data != null) {
            rv = this.deserialize(data);
        } else if (flags != 0 && data != null) {
            switch (flags) {
                case 256: {
                    rv = this.tu.decodeBoolean(data);
                    break;
                }
                case 512: {
                    rv = new Integer(this.tu.decodeInt(data));
                    break;
                }
                case 768: {
                    rv = new Long(this.tu.decodeLong(data));
                    break;
                }
                case 1024: {
                    rv = new Date(this.tu.decodeLong(data));
                    break;
                }
                case 1280: {
                    rv = new Byte(this.tu.decodeByte(data));
                    break;
                }
                case 1536: {
                    rv = new Float(Float.intBitsToFloat(this.tu.decodeInt(data)));
                    break;
                }
                case 1792: {
                    rv = new Double(Double.longBitsToDouble(this.tu.decodeLong(data)));
                    break;
                }
                case 2048: {
                    rv = data;
                    break;
                }
                default: {
                    this.getLogger().warn("Undecodeable with flags %x", flags);
                    break;
                }
            }
        } else {
            rv = this.decodeString(data);
        }
        return rv;
    }

    @Override
    public CachedData encode(Object o) {
        byte[] b = null;
        int flags = 0;
        if (o instanceof String) {
            b = this.encodeString((String)o);
        } else if (o instanceof Long) {
            b = this.tu.encodeLong((Long)o);
            flags |= 0x300;
        } else if (o instanceof Integer) {
            b = this.tu.encodeInt((Integer)o);
            flags |= 0x200;
        } else if (o instanceof Boolean) {
            b = this.tu.encodeBoolean((Boolean)o);
            flags |= 0x100;
        } else if (o instanceof Date) {
            b = this.tu.encodeLong(((Date)o).getTime());
            flags |= 0x400;
        } else if (o instanceof Byte) {
            b = this.tu.encodeByte((Byte)o);
            flags |= 0x500;
        } else if (o instanceof Float) {
            b = this.tu.encodeInt(Float.floatToRawIntBits(((Float)o).floatValue()));
            flags |= 0x600;
        } else if (o instanceof Double) {
            b = this.tu.encodeLong(Double.doubleToRawLongBits((Double)o));
            flags |= 0x700;
        } else if (o instanceof byte[]) {
            b = (byte[])o;
            flags |= 0x800;
        } else {
            b = this.serialize(o);
            flags |= 1;
        }
        assert (b != null);
        return new CachedData(flags, b, this.getMaxSize());
    }
}

