/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.util;

import java.util.Comparator;
import net.spy.memcached.ArcusReplNodeAddress;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedReplicaGroup;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public class ArcusReplKetamaNodeLocatorConfiguration
implements KetamaNodeLocatorConfiguration {
    private static final int NUM_REPS = 160;

    @Override
    public String getKeyForNode(MemcachedNode node, int repetition) {
        ArcusReplNodeAddress addr = (ArcusReplNodeAddress)node.getSocketAddress();
        String key = addr.getGroupName() + "-" + repetition;
        return key;
    }

    public String getKeyForGroup(MemcachedReplicaGroup group, int repetition) {
        String key = group.getGroupName() + "-" + repetition;
        return key;
    }

    @Override
    public int getNodeRepetitions() {
        return 160;
    }

    public static class MemcachedReplicaGroupComparator
    implements Comparator<MemcachedReplicaGroup> {
        @Override
        public int compare(MemcachedReplicaGroup group1, MemcachedReplicaGroup group2) {
            String name1 = group1.getGroupName();
            String name2 = group2.getGroupName();
            return name1.compareTo(name2);
        }
    }
}

