/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.spy.memcached.ArcusClient;
import net.spy.memcached.CachedData;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.BasicThreadFactory;
import net.spy.memcached.internal.CollectionFuture;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.transcoders.Transcoder;

class BulkService
extends SpyObject {
    private static int DEFAULT_LOOP_LIMIT;
    private final ExecutorService executor;
    private final long singleOpTimeout;

    BulkService(int loopLimit, int threadCount, long singleOpTimeout) {
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new BasicThreadFactory("bulk-service", true), new ThreadPoolExecutor.AbortPolicy());
        DEFAULT_LOOP_LIMIT = loopLimit;
        this.singleOpTimeout = singleOpTimeout;
    }

    <T> Future<Map<String, CollectionOperationStatus>> setBulk(List<String> keys, int exp, T value, Transcoder<T> transcoder, ArcusClient[] client) {
        assert (!this.executor.isShutdown()) : "Pool has already shut down.";
        BulkSetWorker<T> w = new BulkSetWorker<T>(keys, exp, value, transcoder, client, this.singleOpTimeout);
        Task<Map<String, CollectionOperationStatus>> task = new Task<Map<String, CollectionOperationStatus>>(w);
        this.executor.submit(task);
        return task;
    }

    <T> Future<Map<String, CollectionOperationStatus>> setBulk(Map<String, T> o, int exp, Transcoder<T> transcoder, ArcusClient[] client) {
        assert (!this.executor.isShutdown()) : "Pool has already shut down.";
        BulkSetWorker<T> w = new BulkSetWorker<T>(o, exp, transcoder, client, this.singleOpTimeout);
        Task<Map<String, CollectionOperationStatus>> task = new Task<Map<String, CollectionOperationStatus>>(w);
        this.executor.submit(task);
        return task;
    }

    void shutdown() {
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"exception while shutting down bulk set service.", e);
        }
    }

    private static class BulkSetWorker<T>
    extends BulkWorker<T> {
        private final List<String> keys;
        private final int exp;
        private final int cntCos;
        private List<CachedData> cos;

        public BulkSetWorker(List<String> keys, int exp, T value, Transcoder<T> transcoder, ArcusClient[] clientList, long timeout) {
            super(keys.size(), timeout, transcoder, clientList);
            this.keys = keys;
            this.exp = exp;
            this.cos = new ArrayList<CachedData>();
            this.cos.add(transcoder.encode(value));
            this.cntCos = 1;
        }

        public BulkSetWorker(Map<String, T> o, int exp, Transcoder<T> transcoder, ArcusClient[] clientList, long timeout) {
            super(o.keySet().size(), timeout, transcoder, clientList);
            this.keys = new ArrayList<String>(o.keySet());
            this.exp = exp;
            this.cos = new ArrayList<CachedData>();
            for (String key : this.keys) {
                this.cos.add(transcoder.encode(o.get(key)));
            }
            this.cntCos = this.cos.size();
        }

        @Override
        public Future<Boolean> processItem(int index) {
            return this.clientList[index % this.clientList.length].asyncStore(StoreType.set, this.keys.get(index), this.exp, this.cntCos > 1 ? this.cos.get(index) : this.cos.get(0));
        }

        @Override
        public void awaitProcessResult(int index) {
            try {
                boolean success = (Boolean)((Future)this.future.get(index)).get(this.operationTimeout, TimeUnit.MILLISECONDS);
                if (!success) {
                    this.errorList.put(this.keys.get(index), new CollectionOperationStatus(false, String.valueOf(success), CollectionResponse.END));
                }
            }
            catch (Exception e) {
                ((Future)this.future.get(index)).cancel(true);
                this.errorList.put(this.keys.get(index), new CollectionOperationStatus(false, e.getMessage(), CollectionResponse.EXCEPTION));
            }
        }

        @Override
        public boolean isDataExists() {
            return this.keys != null && this.keys.size() > 0;
        }
    }

    private static abstract class BulkWorker<T>
    extends SpyObject
    implements Callable<Map<String, CollectionOperationStatus>> {
        protected final ArcusClient[] clientList;
        protected final ArrayList<Future<Boolean>> future;
        protected final long operationTimeout;
        protected final AtomicBoolean isRunnable = new AtomicBoolean(true);
        protected final Map<String, CollectionOperationStatus> errorList;
        protected final int totalCount;
        protected final int fromIndex;
        protected final int toIndex;

        public BulkWorker(int keySize, long timeout, Transcoder<T> tc, ArcusClient[] clientList) {
            this.future = new ArrayList(keySize);
            this.operationTimeout = timeout;
            this.clientList = this.getOptimalClients(clientList);
            this.errorList = new HashMap<String, CollectionOperationStatus>();
            this.fromIndex = 0;
            this.toIndex = keySize - 1;
            this.totalCount = this.toIndex - this.fromIndex + 1;
        }

        public boolean cancel() {
            if (!this.isRunnable()) {
                return false;
            }
            this.isRunnable.set(false);
            boolean ret = true;
            for (Future<Boolean> f : this.future) {
                if (f == null || f.isCancelled() || f.isDone()) continue;
                ret &= f.cancel(true);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Cancel the future. " + f);
            }
            this.getLogger().info("Cancel, bulk set worker.");
            return ret;
        }

        private ArcusClient[] getOptimalClients(ArcusClient[] clientList) {
            return clientList;
        }

        protected boolean isRunnable() {
            return this.isRunnable.get() && !Thread.currentThread().isInterrupted();
        }

        protected void setErrorOpStatus(String key, int indexOfFuture) {
            this.errorList.put(key, ((CollectionFuture)this.future.get(indexOfFuture)).getOperationStatus());
        }

        public abstract Future<Boolean> processItem(int var1);

        public abstract void awaitProcessResult(int var1);

        public abstract boolean isDataExists();

        @Override
        public Map<String, CollectionOperationStatus> call() throws Exception {
            if (!this.isDataExists()) {
                return this.errorList;
            }
            for (int pos = this.fromIndex; this.isRunnable() && pos <= this.toIndex; ++pos) {
                if (pos - this.fromIndex > 0 && (pos - this.fromIndex) % DEFAULT_LOOP_LIMIT == 0) {
                    for (int i = pos - DEFAULT_LOOP_LIMIT; this.isRunnable() && i < pos; ++i) {
                        this.awaitProcessResult(i);
                    }
                }
                try {
                    if (!this.isRunnable()) continue;
                    this.future.add(pos, this.processItem(pos));
                    continue;
                }
                catch (IllegalStateException e) {
                    if (Thread.currentThread().isInterrupted()) break;
                    throw e;
                }
            }
            for (int i = this.toIndex - (this.totalCount % DEFAULT_LOOP_LIMIT == 0 ? DEFAULT_LOOP_LIMIT : this.totalCount % DEFAULT_LOOP_LIMIT) + 1; this.isRunnable() && i <= this.toIndex; ++i) {
                this.awaitProcessResult(i);
            }
            return this.errorList;
        }
    }

    private static class Task<T>
    extends FutureTask<T> {
        private final BulkWorker worker;

        public Task(Callable<T> callable) {
            super(callable);
            this.worker = (BulkWorker)callable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.worker.cancel() && super.cancel(mayInterruptIfRunning);
        }
    }
}

