/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.spy.memcached.ArcusKetamaNodeLocator;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.Transcoder;

public class ConnectionFactoryBuilder {
    private OperationQueueFactory opQueueFactory;
    private OperationQueueFactory readQueueFactory;
    private OperationQueueFactory writeQueueFactory;
    private Transcoder<Object> transcoder;
    private Transcoder<Object> collectionTranscoder;
    private FailureMode failureMode = FailureMode.Cancel;
    private Collection<ConnectionObserver> initialObservers = Collections.emptyList();
    private OperationFactory opFact;
    private Locator locator = Locator.ARCUSCONSISTENT;
    private long opTimeout = -1L;
    private boolean isDaemon = true;
    private boolean shouldOptimize = false;
    private boolean useNagle = false;
    private long maxReconnectDelay = 1L;
    private int readBufSize = -1;
    private HashAlgorithm hashAlg = HashAlgorithm.KETAMA_HASH;
    private AuthDescriptor authDescriptor = null;
    private long opQueueMaxBlockTime = -1L;
    private int timeoutExceptionThreshold = 10;
    private int maxFrontCacheElements = 0;
    private int frontCacheExpireTime = 5;
    private int bulkServiceThreadCount = 1;
    private int bulkServiceLoopLimit = 1;
    private long bulkServiceSingleOpTimeout = 1000L;
    private int maxSMGetChunkSize = 500;
    private String frontCacheName = "ArcusFrontCache_" + this.hashCode();

    public ConnectionFactoryBuilder setOpQueueFactory(OperationQueueFactory q) {
        this.opQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setReadOpQueueFactory(OperationQueueFactory q) {
        this.readQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setWriteOpQueueFactory(OperationQueueFactory q) {
        this.writeQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setOpQueueMaxBlockTime(long t) {
        this.opQueueMaxBlockTime = t;
        return this;
    }

    public ConnectionFactoryBuilder setTranscoder(Transcoder<Object> t) {
        this.transcoder = t;
        return this;
    }

    public ConnectionFactoryBuilder setCollectionTranscoder(Transcoder<Object> t) {
        this.collectionTranscoder = t;
        return this;
    }

    public ConnectionFactoryBuilder setFailureMode(FailureMode fm) {
        this.failureMode = fm;
        return this;
    }

    public ConnectionFactoryBuilder setInitialObservers(Collection<ConnectionObserver> obs) {
        this.initialObservers = obs;
        return this;
    }

    public ConnectionFactoryBuilder setOpFact(OperationFactory f) {
        this.opFact = f;
        return this;
    }

    public ConnectionFactoryBuilder setOpTimeout(long t) {
        this.opTimeout = t;
        return this;
    }

    public ConnectionFactoryBuilder setDaemon(boolean d) {
        this.isDaemon = d;
        return this;
    }

    public ConnectionFactoryBuilder setShouldOptimize(boolean o) {
        this.shouldOptimize = o;
        return this;
    }

    public ConnectionFactoryBuilder setReadBufferSize(int to) {
        this.readBufSize = to;
        return this;
    }

    public ConnectionFactoryBuilder setHashAlg(HashAlgorithm to) {
        this.hashAlg = to;
        return this;
    }

    public ConnectionFactoryBuilder setUseNagleAlgorithm(boolean to) {
        this.useNagle = to;
        return this;
    }

    public ConnectionFactoryBuilder setProtocol(Protocol prot) {
        switch (prot) {
            case TEXT: {
                this.opFact = new AsciiOperationFactory();
                break;
            }
            case BINARY: {
                this.opFact = new BinaryOperationFactory();
                break;
            }
            default: {
                assert (false) : "Unhandled protocol: " + (Object)((Object)prot);
                break;
            }
        }
        return this;
    }

    public ConnectionFactoryBuilder setLocatorType(Locator l) {
        this.locator = l;
        return this;
    }

    public ConnectionFactoryBuilder setMaxReconnectDelay(long to) {
        assert (to > 0L) : "Reconnect delay must be a positive number";
        this.maxReconnectDelay = to;
        return this;
    }

    public ConnectionFactoryBuilder setAuthDescriptor(AuthDescriptor to) {
        this.authDescriptor = to;
        return this;
    }

    public ConnectionFactoryBuilder setTimeoutExceptionThreshold(int to) {
        assert (to > 1) : "Minimum timeout exception threshold is 2";
        if (to > 1) {
            this.timeoutExceptionThreshold = to - 2;
        }
        return this;
    }

    public ConnectionFactoryBuilder setMaxFrontCacheElements(int to) {
        assert (to > 0) : "In case of front cache, the number must be a positive number";
        this.maxFrontCacheElements = to;
        return this;
    }

    public ConnectionFactoryBuilder setFrontCacheExpireTime(int to) {
        assert (to > 0) : "Front cache's expire time must be a positive number";
        this.frontCacheExpireTime = to;
        return this;
    }

    public ConnectionFactoryBuilder setBulkServiceThreadCount(int to) {
        assert (to > 0) : "Bulk service's thread count must be a positive number";
        this.bulkServiceThreadCount = to;
        return this;
    }

    public ConnectionFactoryBuilder setBulkServiceLoopLimit(int to) {
        assert (to > 0) : "Bulk service's loop limit must be a positive number";
        this.bulkServiceLoopLimit = to;
        return this;
    }

    public ConnectionFactoryBuilder setBulkServiceSingleOpTimeout(long to) {
        assert (to > 0L) : "Bulk service's single operation timeout must be a positive number";
        this.bulkServiceSingleOpTimeout = to;
        return this;
    }

    public ConnectionFactoryBuilder setMaxSMGetKeyChunkSize(int size) {
        this.maxSMGetChunkSize = size;
        return this;
    }

    public ConnectionFactory build() {
        return new DefaultConnectionFactory(){

            @Override
            public BlockingQueue<Operation> createOperationQueue() {
                return ConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : ConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createReadOperationQueue() {
                return ConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : ConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createWriteOperationQueue() {
                return ConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : ConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            @Override
            public NodeLocator createLocator(List<MemcachedNode> nodes) {
                switch (ConnectionFactoryBuilder.this.locator) {
                    case ARRAY_MOD: {
                        return new ArrayModNodeLocator(nodes, this.getHashAlg());
                    }
                    case CONSISTENT: {
                        return new KetamaNodeLocator(nodes, this.getHashAlg());
                    }
                    case ARCUSCONSISTENT: {
                        return new ArcusKetamaNodeLocator(nodes, this.getHashAlg());
                    }
                }
                throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)ConnectionFactoryBuilder.this.locator));
            }

            @Override
            public Transcoder<Object> getDefaultTranscoder() {
                return ConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : ConnectionFactoryBuilder.this.transcoder;
            }

            @Override
            public Transcoder<Object> getDefaultCollectionTranscoder() {
                return ConnectionFactoryBuilder.this.collectionTranscoder == null ? super.getDefaultCollectionTranscoder() : ConnectionFactoryBuilder.this.collectionTranscoder;
            }

            @Override
            public FailureMode getFailureMode() {
                return ConnectionFactoryBuilder.this.failureMode == null ? super.getFailureMode() : ConnectionFactoryBuilder.this.failureMode;
            }

            @Override
            public HashAlgorithm getHashAlg() {
                return ConnectionFactoryBuilder.this.hashAlg == null ? super.getHashAlg() : ConnectionFactoryBuilder.this.hashAlg;
            }

            @Override
            public Collection<ConnectionObserver> getInitialObservers() {
                return ConnectionFactoryBuilder.this.initialObservers;
            }

            @Override
            public OperationFactory getOperationFactory() {
                return ConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : ConnectionFactoryBuilder.this.opFact;
            }

            @Override
            public long getOperationTimeout() {
                return ConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : ConnectionFactoryBuilder.this.opTimeout;
            }

            @Override
            public int getReadBufSize() {
                return ConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : ConnectionFactoryBuilder.this.readBufSize;
            }

            @Override
            public boolean isDaemon() {
                return ConnectionFactoryBuilder.this.isDaemon;
            }

            @Override
            public boolean shouldOptimize() {
                return ConnectionFactoryBuilder.this.shouldOptimize;
            }

            @Override
            public boolean useNagleAlgorithm() {
                return ConnectionFactoryBuilder.this.useNagle;
            }

            @Override
            public long getMaxReconnectDelay() {
                return ConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            @Override
            public AuthDescriptor getAuthDescriptor() {
                return ConnectionFactoryBuilder.this.authDescriptor;
            }

            @Override
            public long getOpQueueMaxBlockTime() {
                return ConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? ConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            @Override
            public int getTimeoutExceptionThreshold() {
                return ConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            @Override
            public int getMaxFrontCacheElements() {
                return ConnectionFactoryBuilder.this.maxFrontCacheElements;
            }

            @Override
            public int getFrontCacheExpireTime() {
                return ConnectionFactoryBuilder.this.frontCacheExpireTime;
            }

            @Override
            public int getBulkServiceThreadCount() {
                return ConnectionFactoryBuilder.this.bulkServiceThreadCount;
            }

            @Override
            public int getBulkServiceLoopLimit() {
                return ConnectionFactoryBuilder.this.bulkServiceLoopLimit;
            }

            @Override
            public long getBulkServiceSingleOpTimeout() {
                return ConnectionFactoryBuilder.this.bulkServiceSingleOpTimeout;
            }

            @Override
            public int getDefaultMaxSMGetKeyChunkSize() {
                return ConnectionFactoryBuilder.this.maxSMGetChunkSize;
            }

            @Override
            public String getFrontCacheName() {
                return ConnectionFactoryBuilder.this.frontCacheName;
            }
        };
    }

    public static enum Locator {
        ARRAY_MOD,
        CONSISTENT,
        ARCUSCONSISTENT;

    }

    public static enum Protocol {
        TEXT,
        BINARY;

    }
}

