/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.ascii.AsciiMemcachedNodeImpl;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.CollectionTranscoder;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public class DefaultConnectionFactory
extends SpyObject
implements ConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Redistribute;
    public static final HashAlgorithm DEFAULT_HASH = HashAlgorithm.NATIVE_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_OP_QUEUE_MAX_BLOCK_TIME = TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final long DEFAULT_OPERATION_TIMEOUT = 1000L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = 30L;
    public static final int DEFAULT_MAX_TIMEOUTEXCEPTION_THRESHOLD = 998;
    public static final int DEFAULT_MAX_FRONTCACHE_ELEMENTS = 0;
    public static final int DEFAULT_FRONTCACHE_EXPIRETIME = 5;
    public static final int DEFAULT_BULKSERVICE_THREAD_COUNT = 1;
    public static final int DEFAULT_BULKSERVICE_LOOP_LIMIT = 1;
    public static final long DEFAULT_BULKSERVICE_SINGLE_OP_TIMEOUT = 1000L;
    public static final int DEFAULT_MAX_SMGET_KEY_CHUNK_SIZE = 500;
    private static final String DEFAULT_FRONT_CACHE_NAME = "ArcusFrontCache" + new Object().hashCode();
    private final int opQueueLen;
    private final int readBufSize;
    private final HashAlgorithm hashAlg;

    public DefaultConnectionFactory(int qLen, int bufSize, HashAlgorithm hash) {
        this.opQueueLen = qLen;
        this.readBufSize = bufSize;
        this.hashAlg = hash;
    }

    public DefaultConnectionFactory(int qLen, int bufSize) {
        this(qLen, bufSize, DEFAULT_HASH);
    }

    public DefaultConnectionFactory() {
        this(16384, 16384);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        OperationFactory of = this.getOperationFactory();
        if (of instanceof AsciiOperationFactory) {
            return new AsciiMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), this.getOpQueueMaxBlockTime());
        }
        if (of instanceof BinaryOperationFactory) {
            boolean doAuth = false;
            if (this.getAuthDescriptor() != null) {
                doAuth = true;
            }
            return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth);
        }
        throw new IllegalStateException("Unhandled operation factory type " + of);
    }

    @Override
    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return new MemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
    }

    @Override
    public FailureMode getFailureMode() {
        return DEFAULT_FAILURE_MODE;
    }

    @Override
    public BlockingQueue<Operation> createOperationQueue() {
        return new ArrayBlockingQueue<Operation>(this.getOpQueueLen());
    }

    @Override
    public BlockingQueue<Operation> createReadOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public BlockingQueue<Operation> createWriteOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new ArrayModNodeLocator(nodes, this.getHashAlg());
    }

    public int getOpQueueLen() {
        return this.opQueueLen;
    }

    @Override
    public long getOpQueueMaxBlockTime() {
        return DEFAULT_OP_QUEUE_MAX_BLOCK_TIME;
    }

    @Override
    public int getReadBufSize() {
        return this.readBufSize;
    }

    @Override
    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new AsciiOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return 1000L;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public Collection<ConnectionObserver> getInitialObservers() {
        return Collections.emptyList();
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        return new SerializingTranscoder();
    }

    @Override
    public Transcoder<Object> getDefaultCollectionTranscoder() {
        return new CollectionTranscoder();
    }

    @Override
    public boolean useNagleAlgorithm() {
        return false;
    }

    @Override
    public boolean shouldOptimize() {
        return true;
    }

    @Override
    public long getMaxReconnectDelay() {
        return 30L;
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return null;
    }

    @Override
    public int getTimeoutExceptionThreshold() {
        return 998;
    }

    @Override
    public int getMaxFrontCacheElements() {
        return 0;
    }

    @Override
    public int getFrontCacheExpireTime() {
        return 5;
    }

    @Override
    public int getBulkServiceThreadCount() {
        return 1;
    }

    @Override
    public int getBulkServiceLoopLimit() {
        return 1;
    }

    @Override
    public long getBulkServiceSingleOpTimeout() {
        return 1000L;
    }

    @Override
    public int getDefaultMaxSMGetKeyChunkSize() {
        return 500;
    }

    @Override
    public String getFrontCacheName() {
        return DEFAULT_FRONT_CACHE_NAME;
    }
}

