/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.AbstractList;
import java.util.List;

public class PartitionedList<T>
extends AbstractList<List<T>> {
    private final List<T> list;
    private final int size;

    public PartitionedList(List<T> list, int size) {
        this.list = list;
        this.size = size;
    }

    @Override
    public List<T> get(int index) {
        int listSize = this.size();
        if (listSize < 0) {
            throw new IllegalArgumentException("negative size: " + listSize);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index " + index + " must not be negative");
        }
        if (index >= listSize) {
            throw new IndexOutOfBoundsException("index " + index + " must be less than size " + listSize);
        }
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return (this.list.size() + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

