/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import net.spy.memcached.ArcusClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.protocol.TCPMemcachedNodeImpl;

public class StatisticsHandler
extends SpyObject
implements DynamicMBean {
    private static final String ADDED_Q = "addedQ";
    private static final String INPUT_Q = "inputQ";
    private static final String WRITE_Q = "writeQ";
    private static final String READ_Q = "readQ";
    private static final String RECONN_CNT = "reconnectCount";
    private static final String CONT_TIMEOUT = "continuousTimeout";
    private static final String DELIMETER = "-";
    private final ArcusClient client;
    private final Map<String, MemcachedNode> nodes = new ConcurrentHashMap<String, MemcachedNode>();

    public StatisticsHandler(ArcusClient client) {
        this.client = client;
        Collection<MemcachedNode> allNodes = client.getAllNodes();
        for (MemcachedNode node : allNodes) {
            this.nodes.put(node.getSocketAddress().toString(), node);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.contains(ADDED_Q)) {
            return this.client.getAddedQueueSize();
        }
        TCPMemcachedNodeImpl node = (TCPMemcachedNodeImpl)this.getNode(attribute);
        if (node == null) {
            return null;
        }
        if (attribute.contains(RECONN_CNT)) {
            return node.getReconnectCount();
        }
        if (attribute.contains(CONT_TIMEOUT)) {
            return node.getContinuousTimeout();
        }
        if (attribute.contains(INPUT_Q)) {
            return node.getInputQueueSize();
        }
        if (attribute.contains(READ_Q)) {
            return node.getReadQueueSize();
        }
        if (attribute.contains(WRITE_Q)) {
            return node.getWriteQueueSize();
        }
        throw new AttributeNotFoundException("Atrribute '" + attribute + "' is not defined.");
    }

    private MemcachedNode getNode(String attribute) {
        try {
            if (attribute.contains(DELIMETER)) {
                MemcachedNode memcachedNode = this.nodes.get(attribute.split(DELIMETER)[1]);
                if (memcachedNode instanceof TCPMemcachedNodeImpl) {
                    return memcachedNode;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        attributes.add(new MBeanAttributeInfo(ADDED_Q, "long", "added queue size", true, false, false));
        for (Map.Entry<String, MemcachedNode> entry : this.nodes.entrySet()) {
            attributes.add(new MBeanAttributeInfo("reconnectCount-" + entry.getValue().getSocketAddress().toString(), "int", "reconnect count", true, false, false));
            attributes.add(new MBeanAttributeInfo("continuousTimeout-" + entry.getValue().getSocketAddress().toString(), "int", "continuous timeout count", true, false, false));
            attributes.add(new MBeanAttributeInfo("inputQ-" + entry.getValue().getSocketAddress().toString(), "int", "input queue count", true, false, false));
            attributes.add(new MBeanAttributeInfo("readQ-" + entry.getValue().getSocketAddress().toString(), "int", "read queue count", true, false, false));
            attributes.add(new MBeanAttributeInfo("writeQ-" + entry.getValue().getSocketAddress().toString(), "int", "write queue count", true, false, false));
        }
        this.getLogger().info("retrieve client statistics mbean informations.");
        return new MBeanInfo(this.getClass().getName(), "Arcus client statistics MBean", attributes.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

