/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionCount;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementMultiFlagsFilter;
import net.spy.memcached.util.BTreeUtil;

public class BTreeCount
extends CollectionCount {
    private static final String command = "bop count";
    protected final String range;
    protected final ElementFlagFilter elementFlagFilter;

    public BTreeCount(long from, long to, ElementFlagFilter elementFlagFilter) {
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeCount(byte[] from, byte[] to, ElementFlagFilter elementFlagFilter) {
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeCount(long from, long to, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public BTreeCount(byte[] from, byte[] to, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.elementFlagFilter != null) {
            b.append(" ").append(this.elementFlagFilter.toString());
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

