/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionDelete;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementMultiFlagsFilter;
import net.spy.memcached.util.BTreeUtil;

public class BTreeDelete<T>
extends CollectionDelete<T> {
    private static final String command = "bop delete";
    protected int count = -1;
    protected ElementFlagFilter elementFlagFilter;

    public BTreeDelete(long bkey, boolean noreply) {
        this.range = String.valueOf(bkey);
        this.noreply = noreply;
    }

    public BTreeDelete(long bkey, boolean noreply, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this(bkey, noreply);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeDelete(long from, long to, boolean noreply) {
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.noreply = noreply;
    }

    public BTreeDelete(long from, long to, int count, boolean noreply) {
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.count = count;
        this.noreply = noreply;
    }

    public BTreeDelete(long from, long to, int count, boolean noreply, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this(from, to, count, noreply);
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeDelete(byte[] bkey, boolean noreply, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this.range = BTreeUtil.toHex(bkey);
        this.noreply = noreply;
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeDelete(byte[] from, byte[] to, int count, boolean noreply, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.count = count;
        this.noreply = noreply;
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeDelete(long bkey, boolean noreply, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this(bkey, noreply);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public BTreeDelete(long from, long to, int count, boolean noreply, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this(from, to, count, noreply);
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public BTreeDelete(byte[] bkey, boolean noreply, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this.range = BTreeUtil.toHex(bkey);
        this.noreply = noreply;
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public BTreeDelete(byte[] from, byte[] to, int count, boolean noreply, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.count = count;
        this.noreply = noreply;
        this.dropIfEmpty = dropIfEmpty;
        this.noreply = noreply;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.elementFlagFilter != null) {
            b.append(" ").append(this.elementFlagFilter.toString());
        }
        if (this.count >= 0) {
            b.append(" ").append(this.count);
        }
        if (this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.noreply) {
            b.append(" noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

