/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.BKeyObject;
import net.spy.memcached.collection.BTreeOrder;
import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.util.BTreeUtil;

public class BTreeFindPositionWithGet<T>
extends CollectionGet<T> {
    public static final int HEADER_EFLAG_POSITION = 1;
    private static final String command = "bop pwg";
    private final BKeyObject bkeyObject;
    private final BTreeOrder order;
    private final int count;
    private BKeyObject bkey;
    private byte[] eflag;
    private int bytes;

    public BTreeFindPositionWithGet(long longBKey, BTreeOrder order, int count) {
        this.bkeyObject = new BKeyObject(longBKey);
        this.order = order;
        this.count = count;
    }

    public BTreeFindPositionWithGet(byte[] byteArrayBKey, BTreeOrder order, int count) {
        this.bkeyObject = new BKeyObject(byteArrayBKey);
        this.order = order;
        this.count = count;
    }

    @Override
    public String stringify() {
        if (this.str == null) {
            StringBuilder b = new StringBuilder();
            b.append(this.bkeyObject.getBKeyAsString());
            b.append(" ");
            b.append(this.order.getAscii());
            if (this.count > 0) {
                b.append(" ");
                b.append(String.valueOf(this.count));
            }
            this.str = b.toString();
        }
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    public BKeyObject getBkeyObject() {
        return this.bkeyObject;
    }

    public BTreeOrder getOrder() {
        return this.order;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return spaceCount == 2;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        this.bkey = splited[0].startsWith("0x") ? new BKeyObject(splited[0].substring(2)) : new BKeyObject(Long.parseLong(splited[0]));
        if (splited[1].startsWith("0x")) {
            this.eflag = BTreeUtil.hexStringToByteArrays(splited[1].substring(2));
            this.bytes = Integer.parseInt(splited[2]);
        } else {
            this.bytes = Integer.parseInt(splited[1]);
        }
        this.dataLength = this.bytes;
    }

    public BKeyObject getBkey() {
        return this.bkey;
    }

    public byte[] getEflag() {
        return this.eflag;
    }

    public int getBytes() {
        return this.bytes;
    }
}

