/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import net.spy.memcached.collection.BTreeGetBulkImpl;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public class BTreeGetBulkWithLongTypeBkey<T>
extends BTreeGetBulkImpl<T> {
    public BTreeGetBulkWithLongTypeBkey(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count) {
        super(keyList, from, to, eFlagFilter, offset, count);
    }

    @Override
    public Long getSubkey() {
        return (Long)this.subkey;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        if (splited.length == 3) {
            this.subkey = Long.parseLong(splited[1]);
            this.dataLength = Integer.parseInt(splited[2]);
            this.eflag = null;
        } else if (splited.length == 4) {
            this.subkey = Long.parseLong(splited[1]);
            this.eflag = BTreeUtil.hexStringToByteArrays(splited[2].substring(2));
            this.dataLength = Integer.parseInt(splited[3]);
        }
    }

    @Override
    public void decodeKeyHeader(String keyHeader) {
        String[] splited = keyHeader.split(" ");
        this.key = splited[1];
    }
}

