/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import java.util.Map;
import net.spy.memcached.collection.BTreeSMGet;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public class BTreeSMGetWithByteTypeBkey<T>
implements BTreeSMGet<T> {
    private static final String command = "bop smget";
    protected String str;
    protected List<String> keyList;
    private String commaSeparatedKeys;
    protected int lenKeys;
    protected String range;
    protected int offset = -1;
    protected int count;
    protected Map<Integer, T> map;
    protected boolean reverse;
    public String key;
    public int flag;
    public byte[] subkey;
    public int dataLength;
    public byte[] eflag = null;
    private ElementFlagFilter eFlagFilter;

    public BTreeSMGetWithByteTypeBkey(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count) {
        this.keyList = keyList;
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.eFlagFilter = eFlagFilter;
        this.offset = offset;
        this.count = count;
        this.reverse = BTreeUtil.compareByteArraysInLexOrder(from, to) > 0;
    }

    @Override
    public String getCommaSeparatedKeys() {
        if (this.commaSeparatedKeys != null) {
            return this.commaSeparatedKeys;
        }
        StringBuilder sb = new StringBuilder();
        int numkeys = this.keyList.size();
        for (int i = 0; i < numkeys; ++i) {
            sb.append(this.keyList.get(i));
            if (i + 1 >= numkeys) continue;
            sb.append(",");
        }
        this.commaSeparatedKeys = sb.toString();
        return this.commaSeparatedKeys;
    }

    @Override
    public String getRepresentKey() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            throw new IllegalStateException("Key list is empty.");
        }
        return this.keyList.get(0);
    }

    @Override
    public List<String> getKeyList() {
        return this.keyList;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.getCommaSeparatedKeys().length());
        b.append(" ").append(this.keyList.size());
        b.append(" ").append(this.range);
        if (this.eFlagFilter != null) {
            b.append(" ").append(this.eFlagFilter.toString());
        }
        if (this.offset > 0) {
            b.append(" ").append(this.offset);
        }
        b.append(" ").append(this.count);
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return 4 == spaceCount;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getFlag() {
        return this.flag;
    }

    public byte[] getSubkey() {
        return this.subkey;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean hasEflag() {
        return this.eflag != null;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        this.key = splited[0];
        this.flag = Integer.parseInt(splited[1]);
        this.subkey = BTreeUtil.hexStringToByteArrays(splited[2].substring(2));
        if (splited[3].startsWith("0x")) {
            this.eflag = BTreeUtil.hexStringToByteArrays(splited[3].substring(2));
            this.dataLength = Integer.parseInt(splited[4]);
        } else {
            this.eflag = null;
            this.dataLength = Integer.parseInt(splited[3]);
        }
    }
}

