/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.RequestMode;
import net.spy.memcached.util.BTreeUtil;

public abstract class CollectionStore<T> {
    protected boolean createKeyIfNotExists = false;
    protected int flags = 0;
    protected T value;
    protected RequestMode requestMode;
    protected CollectionAttributes attribute;
    protected byte[] elementFlag;
    protected String str;

    public CollectionStore() {
    }

    public CollectionStore(T value, byte[] elementFlag, boolean createKeyIfNotExists, RequestMode requestMode, CollectionAttributes attr) {
        if (elementFlag != null && elementFlag.length > 31) {
            throw new IllegalArgumentException("Length of elementFlag must be less than 31");
        }
        this.value = value;
        this.elementFlag = elementFlag;
        this.createKeyIfNotExists = createKeyIfNotExists;
        this.requestMode = requestMode;
        this.attribute = attr;
    }

    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        if (this.createKeyIfNotExists) {
            b.append("create ").append(this.flags);
            if (this.attribute != null) {
                b.append(" ").append(this.attribute.getExpireTime() == null ? CollectionAttributes.DEFAULT_EXPIRETIME : this.attribute.getExpireTime());
                b.append(" ").append(this.attribute.getMaxCount() == null ? CollectionAttributes.DEFAULT_MAXCOUNT : this.attribute.getMaxCount());
                if (null != this.attribute.getOverflowAction()) {
                    b.append(" ").append((Object)this.attribute.getOverflowAction());
                }
                if (null != this.attribute.getReadable() && !this.attribute.getReadable().booleanValue()) {
                    b.append(" ").append("unreadable");
                }
            } else {
                b.append(" ").append(CollectionAttributes.DEFAULT_EXPIRETIME);
                b.append(" ").append(CollectionAttributes.DEFAULT_MAXCOUNT);
            }
        }
        if (this.requestMode != null) {
            b.append(b.length() <= 0 ? "" : " ").append(this.requestMode.getAscii());
        }
        this.str = b.toString();
        return this.str;
    }

    public byte[] getElementFlag() {
        return this.elementFlag;
    }

    public String getElementFlagByHex() {
        if (this.elementFlag == null) {
            return "";
        }
        if (this.elementFlag.length == 0) {
            return "0";
        }
        return BTreeUtil.toHex(this.elementFlag);
    }

    public boolean iscreateKeyIfNotExists() {
        return this.createKeyIfNotExists;
    }

    public void setcreateKeyIfNotExists(boolean createKeyIfNotExists) {
        this.createKeyIfNotExists = createKeyIfNotExists;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public RequestMode getRequestMode() {
        return this.requestMode;
    }

    public void setRequestMode(RequestMode requestMode) {
        this.requestMode = requestMode;
    }

    public void setElementFlag(byte[] elementFlag) {
        this.elementFlag = elementFlag;
    }

    public void setCollectionAttributes(CollectionAttributes attributes) {
        this.attribute = attributes;
    }

    public String toString() {
        return this.str != null ? this.str : this.stringify();
    }

    public abstract String getCommand();
}

