/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.util.BTreeUtil;

public abstract class CollectionUpdate<T> {
    protected boolean createKeyIfNotExists = false;
    protected int flags = 0;
    protected T newValue;
    protected boolean noreply = false;
    protected int flagOffset = -1;
    protected ElementFlagFilter.BitWiseOperands bitOp;
    protected byte[] elementFlag;
    protected String str;

    public CollectionUpdate() {
    }

    public CollectionUpdate(T newValue, ElementFlagUpdate elementFlagUpdate, boolean noreply) {
        if (elementFlagUpdate == null) {
            this.newValue = newValue;
            this.flagOffset = -1;
            this.bitOp = null;
            this.elementFlag = null;
        } else {
            if (newValue == null && elementFlagUpdate.getElementFlag() == null) {
                throw new IllegalArgumentException("One of the newValue or elementFlag must not be null.");
            }
            if (elementFlagUpdate.getElementFlag().length > 31) {
                throw new IllegalArgumentException("length of element flag cannot exceed 31");
            }
            this.newValue = newValue;
            this.flagOffset = elementFlagUpdate.getElementFlagOffset();
            this.bitOp = elementFlagUpdate.getBitOp();
            this.elementFlag = elementFlagUpdate.getElementFlag();
        }
        this.noreply = noreply;
    }

    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        if (this.flagOffset > -1 && this.bitOp != null && this.elementFlag != null) {
            b.append(this.flagOffset).append(" ").append((Object)this.bitOp).append(" ");
        }
        if (this.elementFlag != null) {
            b.append(this.getElementFlagByHex());
        }
        if (this.noreply) {
            b.append(b.length() <= 0 ? "" : " ").append("noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    public String getElementFlagByHex() {
        if (this.elementFlag == null) {
            return "";
        }
        if (this.elementFlag.length == 0) {
            return "0";
        }
        return BTreeUtil.toHex(this.elementFlag);
    }

    public boolean iscreateKeyIfNotExists() {
        return this.createKeyIfNotExists;
    }

    public void setcreateKeyIfNotExists(boolean createKeyIfNotExists) {
        this.createKeyIfNotExists = createKeyIfNotExists;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public void setNewValue(T newValue) {
        this.newValue = newValue;
    }

    public boolean isNoreply() {
        return this.noreply;
    }

    public void setNoreply(boolean noreply) {
        this.noreply = noreply;
    }

    public void setElementFlag(byte[] elementFlag) {
        this.elementFlag = elementFlag;
    }

    public String toString() {
        return this.str != null ? this.str : this.stringify();
    }

    public abstract String getCommand();
}

