/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.util.BTreeUtil;

public class Element<T> {
    private final byte[] bkey;
    private final Long longBkey;
    private final T value;
    private final byte[] eflag;
    private final ElementFlagUpdate elementFlagUpdate;
    private final boolean isByteArraysBkey;

    public Element(byte[] bkey, T value, byte[] eflag) {
        this.bkey = bkey;
        this.longBkey = null;
        this.value = value;
        this.eflag = eflag;
        this.isByteArraysBkey = true;
        this.elementFlagUpdate = null;
    }

    public Element(long bkey, T value, byte[] eflag) {
        this.bkey = null;
        this.longBkey = bkey;
        this.value = value;
        this.eflag = eflag;
        this.isByteArraysBkey = false;
        this.elementFlagUpdate = null;
    }

    public Element(byte[] bkey, T value, ElementFlagUpdate elementFlagUpdate) {
        this.bkey = bkey;
        this.longBkey = null;
        this.value = value;
        this.eflag = null;
        this.isByteArraysBkey = true;
        this.elementFlagUpdate = elementFlagUpdate;
    }

    public Element(long bkey, T value, ElementFlagUpdate elementFlagUpdate) {
        this.bkey = null;
        this.longBkey = bkey;
        this.value = value;
        this.eflag = null;
        this.isByteArraysBkey = false;
        this.elementFlagUpdate = elementFlagUpdate;
    }

    public String getFlagByHex() {
        return BTreeUtil.toHex(this.eflag);
    }

    public String getBkeyByHex() {
        return BTreeUtil.toHex(this.bkey);
    }

    public byte[] getByteArrayBkey() {
        return this.bkey;
    }

    public long getLongBkey() {
        return this.longBkey == null ? -1L : this.longBkey;
    }

    public T getValue() {
        return this.value;
    }

    public byte[] getFlag() {
        return this.eflag;
    }

    public boolean isByteArraysBkey() {
        return this.isByteArraysBkey;
    }

    public ElementFlagUpdate getElementFlagUpdate() {
        return this.elementFlagUpdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"");
        if (this.isByteArraysBkey) {
            sb.append(this.getBkeyByHex());
        } else {
            sb.append(this.getLongBkey());
        }
        sb.append("\" : { ");
        sb.append(" \"eflag\" : \"").append(BTreeUtil.toHex(this.eflag)).append("\"");
        sb.append(",");
        sb.append(" \"value\" : \"").append(this.value.toString()).append("\"");
        sb.append(" }");
        return sb.toString();
    }
}

