/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.util.BTreeUtil;

public class ElementFlagFilter {
    public static final ElementFlagFilter DO_NOT_FILTER = null;
    public static final byte[] EMPTY_ELEMENT_FLAG = null;
    public static final int MAX_EFLAG_LENGTH = 31;
    protected int fwhere = 0;
    protected BitWiseOperands bitOp = null;
    protected byte[] bitCompValue = null;
    protected CompOperands compOp;
    protected byte[] compValue;

    public ElementFlagFilter() {
    }

    public ElementFlagFilter(CompOperands compOperand, byte[] compValue) {
        if (compOperand == null || compValue == null) {
            throw new NullPointerException("Invalid compOperand and compValue.");
        }
        if (compValue.length == 0) {
            throw new IllegalArgumentException("Length of comparison value must be larger than 0.");
        }
        if (compValue.length > 31) {
            throw new IllegalArgumentException("Length of comparison value must be less than 31");
        }
        this.compOp = compOperand;
        this.compValue = compValue;
    }

    public ElementFlagFilter setBitOperand(BitWiseOperands bitOp, byte[] bitCompValue) {
        if (bitOp == null || bitCompValue == null) {
            throw new NullPointerException("Invalid compOperand and compValue.");
        }
        if (bitCompValue.length == 0) {
            throw new IllegalArgumentException("Length of bit comparison value must be larger than 0.");
        }
        if (bitCompValue.length > 31) {
            throw new IllegalArgumentException("Length of bit comparison value must be less than 31");
        }
        this.bitOp = bitOp;
        this.bitCompValue = bitCompValue;
        return this;
    }

    public ElementFlagFilter setCompareOffset(int offset) {
        this.fwhere = offset;
        return this;
    }

    protected boolean isBitWiseOpEnabled() {
        return this.bitOp != null && this.bitCompValue != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fwhere).append(" ");
        if (this.isBitWiseOpEnabled()) {
            sb.append((Object)this.bitOp).append(" ");
            sb.append(BTreeUtil.toHex(this.bitCompValue)).append(" ");
        }
        sb.append((Object)this.compOp).append(" ");
        sb.append(BTreeUtil.toHex(this.compValue));
        return sb.toString();
    }

    public static enum BitWiseOperands {
        AND("&"),
        OR("|"),
        XOR("^");

        private String op;

        private BitWiseOperands(String operand) {
            this.op = operand;
        }

        public String toString() {
            return this.op;
        }
    }

    public static enum CompOperands {
        Equal("EQ"),
        NotEqual("NE"),
        LessThan("LT"),
        LessOrEqual("LE"),
        GreaterThan("GT"),
        GreaterOrEqual("GE");

        private String op;

        private CompOperands(String operand) {
            this.op = operand;
        }

        public String toString() {
            return this.op;
        }
    }
}

