/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.util.BTreeUtil;

public class SMGetElement<T>
implements Comparable<SMGetElement<T>> {
    private String key;
    private long bkey;
    private byte[] bytebkey;
    private T value;

    public SMGetElement(String key, long bkey, T value) {
        this.key = key;
        this.bkey = bkey;
        this.bytebkey = null;
        this.value = value;
    }

    public SMGetElement(String key, byte[] bkey, T value) {
        this.key = key;
        this.bkey = -1L;
        this.bytebkey = bkey;
        this.value = value;
    }

    public String toString() {
        return "SMGetElement {KEY:" + this.key + ", BKEY:" + (this.bytebkey == null ? Long.valueOf(this.bkey) : BTreeUtil.toHex(this.bytebkey)) + ", VALUE:" + this.value + "}";
    }

    @Override
    public int compareTo(SMGetElement<T> param) {
        int compareBKey;
        if (this.key == null) {
            return 1;
        }
        if (param == null || param.getKey() == null) {
            return 0;
        }
        int compareKey = this.key.compareTo(param.getKey());
        int n = compareBKey = this.bytebkey == null ? (int)(param.getBkey() - this.bkey) : BTreeUtil.compareByteArraysInLexOrder(param.getByteBkey(), this.bytebkey);
        if (compareBKey != 0) {
            return compareBKey;
        }
        return compareKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getBkey() {
        if (this.bkey == -1L) {
            throw new IllegalStateException("This element has byte[] bkey. " + this.toString());
        }
        return this.bkey;
    }

    public byte[] getByteBkey() {
        if (this.bytebkey == null) {
            throw new IllegalStateException("This element has java.lang.Long type bkey. " + this.toString());
        }
        return this.bytebkey;
    }

    public Object getBkeyByObject() {
        if (this.bytebkey != null) {
            return this.bytebkey;
        }
        return this.bkey;
    }

    public void setBkey(long bkey) {
        this.bkey = bkey;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasByteArrayBkey() {
        return this.bytebkey != null;
    }
}

