/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;

public abstract class SMGetFuture<T>
implements Future<T> {
    private final Collection<Operation> ops;
    private final long timeout;

    public SMGetFuture(Collection<Operation> ops, long timeout) {
        this.ops = ops;
        this.timeout = timeout;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for smget operation", e);
        }
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean rv = false;
        for (Operation op : this.ops) {
            op.cancel();
            rv |= op.getState() == OperationState.WRITING;
        }
        return rv;
    }

    @Override
    public boolean isCancelled() {
        boolean rv = false;
        for (Operation op : this.ops) {
            rv |= op.isCancelled();
        }
        return rv;
    }

    @Override
    public boolean isDone() {
        boolean rv = true;
        for (Operation op : this.ops) {
            rv &= op.getState() == OperationState.COMPLETE;
        }
        return rv || this.isCancelled();
    }

    public abstract List<String> getMissedKeyList();

    public abstract CollectionOperationStatus getOperationStatus();
}

