/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.BTreeFindPosition;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.BTreeFindPositionOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class BTreeFindPositionOperationImpl
extends OperationImpl
implements BTreeFindPositionOperation {
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus POSITION = new CollectionOperationStatus(true, "POSITION", CollectionResponse.OK);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    protected final String key;
    protected final BTreeFindPosition get;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;

    public BTreeFindPositionOperationImpl(String key, BTreeFindPosition get, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.get = get;
    }

    @Override
    public BTreeFindPosition getGet() {
        return this.get;
    }

    @Override
    public void handleLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Got line %s", line);
        }
        Integer position = null;
        if (line.startsWith("POSITION=")) {
            String[] stuff = line.split("=");
            assert (stuff.length == 2);
            assert ("POSITION".equals(stuff[0]));
            try {
                position = Integer.parseInt(stuff[1]);
                BTreeFindPositionOperation.Callback cb = (BTreeFindPositionOperation.Callback)this.getCallback();
                cb.gotData(position);
                this.getCallback().receivedStatus(POSITION);
            }
            catch (Exception e) {}
        } else {
            OperationStatus status = this.matchStatus(line, NOT_FOUND, UNREADABLE, BKEY_MISMATCH, TYPE_MISMATCH, NOT_FOUND_ELEMENT);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(status);
            }
            this.getCallback().receivedStatus(status);
        }
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String cmd = this.get.getCommand();
        String args = this.get.stringify();
        ByteBuffer bb = ByteBuffer.allocate(cmd.length() + this.key.length() + args.length() + 16);
        this.setArguments(bb, cmd, this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

