/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.CollectionGetOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

public class CollectionGetOperationImpl
extends OperationImpl
implements CollectionGetOperation {
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus DELETED = new CollectionOperationStatus(true, "DELETED", CollectionResponse.DELETED);
    private static final OperationStatus DELETED_DROPPED = new CollectionOperationStatus(true, "DELETED_DROPPED", CollectionResponse.DELETED_DROPPED);
    private static final OperationStatus TRIMMED = new CollectionOperationStatus(true, "TRIMMED", CollectionResponse.TRIMMED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    protected final String key;
    protected final CollectionGet<?> collectionGet;
    protected int flags = 0;
    protected int count = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;

    public CollectionGetOperationImpl(String key, CollectionGet<?> collectionGet, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.collectionGet = collectionGet;
    }

    @Override
    public void handleLine(String line) {
        String[] stuff;
        if (line.startsWith("VALUE ")) {
            this.getLogger().debug("Got line %s", line);
            stuff = line.split(" ");
            assert ("VALUE".equals(stuff[0]));
        } else {
            OperationStatus status = this.matchStatus(line, END, TRIMMED, DELETED, DELETED_DROPPED, NOT_FOUND, NOT_FOUND_ELEMENT, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH, UNREADABLE);
            this.getLogger().debug(status);
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
        this.flags = Integer.parseInt(stuff[1]);
        this.count = Integer.parseInt(stuff[2]);
        this.setReadType(OperationReadType.DATA);
    }

    @Override
    public final void handleRead(ByteBuffer bb) {
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b == 32) {
                    ++this.spaceCount;
                    if (this.collectionGet.headerReady(this.spaceCount)) {
                        this.collectionGet.decodeItemHeader(new String(this.byteBuffer.toByteArray()));
                        this.byteBuffer.reset();
                        if (this.collectionGet.headerReady(this.spaceCount) && this.collectionGet.eachRecordParseCompleted()) {
                            this.data = new byte[this.collectionGet.getDataLength()];
                            this.spaceCount = 0;
                            break;
                        }
                    }
                }
                if (b != 13) {
                    if (b == 10) {
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), END, TRIMMED, DELETED, DELETED_DROPPED, NOT_FOUND, NOT_FOUND_ELEMENT, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH, UNREADABLE);
                        this.getLogger().debug("Get complete!");
                        this.getCallback().receivedStatus(status);
                        this.transitionState(OperationState.COMPLETE);
                        this.data = null;
                        break;
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        assert (this.key != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = bb.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d bytes", toRead);
            bb.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.lookingFor == 0 && this.readOffset == this.data.length) {
            CollectionGetOperation.Callback cb = (CollectionGetOperation.Callback)this.getCallback();
            cb.gotData(this.key, this.collectionGet.getSubkey(), this.flags, this.data);
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && bb.hasRemaining()) {
            do {
                byte tmp = bb.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && bb.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
            }
        }
    }

    @Override
    public void initialize() {
        String cmd = this.collectionGet.getCommand();
        String args = this.collectionGet.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.key.length() + cmd.length() + args.length() + 16);
        this.setArguments(bb, cmd, this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionGet<?> getGet() {
        return this.collectionGet;
    }
}

