/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.CollectionStore;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.CollectionStoreOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionUpsertOperationImpl
extends OperationImpl
implements CollectionStoreOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus CREATED_STORED = new CollectionOperationStatus(true, "CREATED_STORED", CollectionResponse.CREATED_STORED);
    private static final OperationStatus STORED = new CollectionOperationStatus(true, "STORED", CollectionResponse.STORED);
    private static final OperationStatus REPLACED = new CollectionOperationStatus(true, "REPLACED", CollectionResponse.REPLACED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ELEMENT_EXISTS = new CollectionOperationStatus(false, "ELEMENT_EXISTS", CollectionResponse.ELEMENT_EXISTS);
    private static final OperationStatus OVERFLOWED = new CollectionOperationStatus(false, "OVERFLOWED", CollectionResponse.OVERFLOWED);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus LENGTH_MISMATCH = new CollectionOperationStatus(false, "LENGTH_MISMATCH", CollectionResponse.LENGTH_MISMATCH);
    protected final String key;
    protected final String subkey;
    protected final CollectionStore<?> collectionStore;
    protected final byte[] data;

    public CollectionUpsertOperationImpl(String key, String subkey, CollectionStore<?> collectionStore, byte[] data, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.subkey = subkey;
        this.collectionStore = collectionStore;
        this.data = data;
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        this.getCallback().receivedStatus(this.matchStatus(line, STORED, REPLACED, CREATED_STORED, NOT_FOUND, ELEMENT_EXISTS, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, LENGTH_MISMATCH));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String args = this.collectionStore.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.key).length + KeyUtil.getKeyBytes(this.subkey).length + KeyUtil.getKeyBytes(this.collectionStore.getElementFlagByHex()).length + args.length() + 32);
        this.setArguments(bb, this.collectionStore.getCommand(), this.key, this.subkey, this.collectionStore.getElementFlagByHex(), this.data.length, args);
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replaceAll("\\r\\n", "\r\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(STORE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public String getSubKey() {
        return this.subkey;
    }

    @Override
    public CollectionStore<?> getStore() {
        return this.collectionStore;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

