/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.arcus.spring;

import net.spy.memcached.ArcusClient;
import net.spy.memcached.ArcusClientPool;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.transcoders.Transcoder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ArcusClientFactoryBean
implements FactoryBean<ArcusClientPool>,
DisposableBean,
InitializingBean {
    private ArcusClientPool client;
    private String url;
    private String serviceCode;
    private int poolSize = 4;
    private int frontCacheExpireTime = 5;
    private int maxFrontCacheElements = 0;
    private boolean frontCacheCopyOnRead = false;
    private boolean frontCacheCopyOnWrite = false;
    private int timeoutExceptionThreshold = 100;
    private long maxReconnectDelay = 30L;
    private Transcoder<Object> globalTranscoder;

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setFrontCacheExpireTime(int frontCacheExpireTime) {
        this.frontCacheExpireTime = frontCacheExpireTime;
    }

    public void setMaxFrontCacheElements(int maxFrontCacheElements) {
        this.maxFrontCacheElements = maxFrontCacheElements;
    }

    public void setFrontCacheCopyOnRead(boolean copyOnRead) {
        this.frontCacheCopyOnRead = copyOnRead;
    }

    public void setFrontCacheCopyOnWrite(boolean copyOnWrite) {
        this.frontCacheCopyOnWrite = copyOnWrite;
    }

    public void setGlobalTranscoder(Transcoder<Object> tc) {
        this.globalTranscoder = tc;
    }

    public void setTimeoutExceptionThreshold(int timeoutExceptionThreshold) {
        this.timeoutExceptionThreshold = timeoutExceptionThreshold;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void destroy() throws Exception {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public ArcusClientPool getObject() throws Exception {
        ConnectionFactoryBuilder cfb = new ConnectionFactoryBuilder();
        cfb.setFrontCacheExpireTime(this.frontCacheExpireTime);
        cfb.setTimeoutExceptionThreshold(this.timeoutExceptionThreshold);
        cfb.setFrontCacheCopyOnRead(this.frontCacheCopyOnRead);
        cfb.setFrontCacheCopyOnWrite(this.frontCacheCopyOnWrite);
        cfb.setMaxReconnectDelay(this.maxReconnectDelay);
        if (this.maxFrontCacheElements > 0) {
            cfb.setMaxFrontCacheElements(this.maxFrontCacheElements);
        }
        if (this.globalTranscoder != null) {
            cfb.setTranscoder(this.globalTranscoder);
        }
        this.client = ArcusClient.createArcusClientPool((String)this.url, (String)this.serviceCode, (ConnectionFactoryBuilder)cfb, (int)this.poolSize);
        return this.client;
    }

    public Class<?> getObjectType() {
        return ArcusClientPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.url, (String)"Url property must be provided.");
        Assert.notNull((Object)this.serviceCode, (String)"ServiceCode property must be provided.");
        Assert.isTrue((this.poolSize > 0 ? 1 : 0) != 0, (String)"PoolSize property must be larger than 0.");
        Assert.isTrue((this.timeoutExceptionThreshold > 0 ? 1 : 0) != 0, (String)"TimeoutExceptionThreshold must be larger than 0.");
        Assert.isTrue((this.maxReconnectDelay > 0L ? 1 : 0) != 0, (String)"MaxReconnectDelay must be larger than 0.");
    }
}

