/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.arcus.spring.cache;

import com.navercorp.arcus.spring.cache.ArcusStringKey;
import com.navercorp.arcus.spring.concurrent.DefaultKeyLockProvider;
import com.navercorp.arcus.spring.concurrent.KeyLockProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ArcusClientPool;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

public class ArcusCache
implements Cache,
InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String prefix;
    private String serviceId;
    private int expireSeconds;
    private long timeoutMilliSeconds = 300L;
    private ArcusClientPool arcusClient;
    @Deprecated
    private boolean wantToGetException;
    private Transcoder<Object> operationTranscoder;
    private KeyLockProvider keyLockProvider = new DefaultKeyLockProvider();

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.arcusClient;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value;
        block2: {
            value = null;
            String cacheKey = null;
            try {
                cacheKey = this.createArcusKey(key);
                this.logger.debug("getting value by key: {}", (Object)cacheKey);
                GetFuture future = this.operationTranscoder != null ? this.arcusClient.asyncGet(cacheKey, this.operationTranscoder) : this.arcusClient.asyncGet(cacheKey);
                value = future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage());
                if (!this.wantToGetException) break block2;
                throw new RuntimeException(e);
            }
        }
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            Object value = this.getValue(this.createArcusKey(key));
            if (value != null && type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
            return (T)value;
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            throw this.toRuntimeException(e);
        }
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        String arcusKey = this.createArcusKey(key);
        try {
            value = this.getValue(arcusKey);
            if (value != null) {
                return (T)value;
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            throw this.toRuntimeException(e);
        }
        try {
            this.acquireWriteLockOnKey(arcusKey);
            value = this.getValue(arcusKey);
            if (value != null) {
                Object e = value;
                return (T)e;
            }
            value = valueLoader.call();
            this.putValue(arcusKey, value);
            Object e = value;
            return (T)e;
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            throw this.toRuntimeException(e);
        }
        finally {
            this.releaseWriteLockOnKey(arcusKey);
        }
    }

    public void put(Object key, Object value) {
        block4: {
            try {
                String cacheKey = this.createArcusKey(key);
                this.logger.debug("trying to put key: {}, value: {}", (Object)cacheKey, value != null ? value.getClass().getName() : null);
                if (value == null) {
                    this.logger.info("arcus cannot put NULL value. key: {}, value: {}", (Object)key.toString(), value);
                    return;
                }
                OperationFuture future = this.operationTranscoder != null ? this.arcusClient.set(cacheKey, this.expireSeconds, value, this.operationTranscoder) : this.arcusClient.set(cacheKey, this.expireSeconds, value);
                boolean success = (Boolean)future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
                if (this.logger.isDebugEnabled() && !success) {
                    this.logger.debug("failed to put a key: {}, value: {}", (Object)key.toString(), value);
                }
            }
            catch (Exception e) {
                this.logger.info("error: {}, with value: {}", (Object)e.getMessage(), value);
                if (!this.wantToGetException) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        try {
            String arcusKey = this.createArcusKey(key);
            this.logger.debug("trying to add key: {}, value: {}", (Object)arcusKey, value != null ? value.getClass().getName() : null);
            if (value == null) {
                throw new IllegalArgumentException("arcus cannot add NULL value. key: " + arcusKey);
            }
            OperationFuture future = this.operationTranscoder != null ? this.arcusClient.add(arcusKey, this.expireSeconds, value, this.operationTranscoder) : this.arcusClient.add(arcusKey, this.expireSeconds, value);
            boolean added = (Boolean)future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
            return added ? null : new SimpleValueWrapper(this.getValue(arcusKey));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            throw this.toRuntimeException(e);
        }
    }

    public void evict(Object key) {
        block4: {
            try {
                String cacheKey = this.createArcusKey(key);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("evicting a key: {}", (Object)cacheKey);
                }
                OperationFuture future = this.arcusClient.delete(cacheKey);
                boolean success = (Boolean)future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
                if (this.logger.isDebugEnabled() && !success) {
                    this.logger.debug("failed to evivt a key: {}", (Object)key.toString());
                }
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
                if (!this.wantToGetException) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public void clear() {
        block4: {
            try {
                String prefixName;
                String string = prefixName = this.prefix != null ? this.prefix : this.name;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("evicting every key that uses the name: {}", (Object)prefixName);
                }
                OperationFuture future = this.arcusClient.flush(this.serviceId + prefixName);
                boolean success = (Boolean)future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
                if (this.logger.isDebugEnabled() && !success) {
                    this.logger.debug("failed to evicting every key that uses the name: {}", (Object)prefixName);
                }
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
                if (!this.wantToGetException) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public String createArcusKey(Object key) {
        String keyString;
        Assert.notNull((Object)key);
        if (key instanceof ArcusStringKey) {
            keyString = ((ArcusStringKey)key).getStringKey();
        } else if (key instanceof Integer) {
            keyString = key.toString();
        } else {
            keyString = key.toString();
            int hash = ArcusStringKey.light_hash(keyString);
            keyString = keyString.replace(' ', '_') + hash;
        }
        String arcusKey = this.prefix != null ? this.serviceId + this.prefix + ":" + keyString : this.serviceId + this.name + ":" + keyString;
        if (arcusKey.length() > 250) {
            String digestedString = DigestUtils.md5DigestAsHex((byte[])keyString.getBytes());
            arcusKey = this.prefix != null ? this.serviceId + this.prefix + ":" + digestedString : this.serviceId + this.name + ":" + digestedString;
        }
        return arcusKey;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public void setTimeoutMilliSeconds(long timeoutMilliseconds) {
        this.timeoutMilliSeconds = timeoutMilliseconds;
    }

    public void setArcusClient(ArcusClientPool arcusClient) {
        this.arcusClient = arcusClient;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.name == null && this.prefix == null) {
            throw new IllegalArgumentException("ArcusCache's 'name' or 'prefix' property must have a value.");
        }
        Assert.notNull((Object)this.serviceId, (String)"ArcusCache's serviceId property must have a value.");
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Deprecated
    public boolean isWantToGetException() {
        return this.wantToGetException;
    }

    @Deprecated
    public void setWantToGetException(boolean wantToGetException) {
        this.wantToGetException = wantToGetException;
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    public long getTimeoutMilliSeconds() {
        return this.timeoutMilliSeconds;
    }

    public ArcusClientPool getArcusClient() {
        return this.arcusClient;
    }

    public Transcoder<Object> getOperationTranscoder() {
        return this.operationTranscoder;
    }

    public void setOperationTranscoder(Transcoder<Object> operationTranscoder) {
        this.operationTranscoder = operationTranscoder;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public KeyLockProvider getKeyLockProvider() {
        return this.keyLockProvider;
    }

    public void setKeyLockProvider(KeyLockProvider keyLockProvider) {
        this.keyLockProvider = keyLockProvider;
    }

    private void acquireWriteLockOnKey(String arcusKey) {
        this.keyLockProvider.getLockForKey(arcusKey).writeLock().lock();
    }

    private void releaseWriteLockOnKey(String arcusKey) {
        this.keyLockProvider.getLockForKey(arcusKey).writeLock().unlock();
    }

    private RuntimeException toRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private Cache.ValueWrapper toValueWrapper(Object value) {
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    private Object getValue(String arcusKey) throws Exception {
        this.logger.debug("getting value by key: {}", (Object)arcusKey);
        GetFuture future = this.operationTranscoder != null ? this.arcusClient.asyncGet(arcusKey, this.operationTranscoder) : this.arcusClient.asyncGet(arcusKey);
        return future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
    }

    private void putValue(String arcusKey, Object value) throws Exception {
        this.logger.debug("trying to put key: {}, value: {}", (Object)arcusKey, value != null ? value.getClass().getName() : null);
        if (value == null) {
            throw new IllegalArgumentException("arcus cannot put NULL value. key: " + arcusKey);
        }
        OperationFuture future = this.operationTranscoder != null ? this.arcusClient.set(arcusKey, this.expireSeconds, value, this.operationTranscoder) : this.arcusClient.set(arcusKey, this.expireSeconds, value);
        boolean success = (Boolean)future.get(this.timeoutMilliSeconds, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled() && !success) {
            this.logger.debug("failed to put a key: {}, value: {}", (Object)arcusKey, value);
        }
    }
}

