/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.arcus.spring.cache;

import com.navercorp.arcus.spring.cache.ArcusCache;
import com.navercorp.arcus.spring.cache.ArcusCacheConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.spy.memcached.ArcusClient;
import net.spy.memcached.ArcusClientPool;
import net.spy.memcached.ConnectionFactoryBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;

public class ArcusCacheManager
extends AbstractCacheManager
implements DisposableBean {
    private ArcusClientPool client;
    protected ArcusCacheConfiguration defaultConfiguration;
    protected Map<String, ArcusCacheConfiguration> initialCacheConfigs;
    private boolean internalClient;

    public ArcusCacheManager(ArcusClientPool client, ArcusCacheConfiguration defaultConfiguration, Map<String, ArcusCacheConfiguration> initialCacheConfigs) {
        this.client = client;
        this.defaultConfiguration = defaultConfiguration;
        this.initialCacheConfigs = initialCacheConfigs;
        this.internalClient = false;
    }

    public ArcusCacheManager(String adminAddress, String serviceCode, ConnectionFactoryBuilder connectionFactoryBuilder, int poolSize, ArcusCacheConfiguration defaultConfiguration, Map<String, ArcusCacheConfiguration> initialCacheConfigs) {
        this(ArcusClient.createArcusClientPool((String)adminAddress, (String)serviceCode, (ConnectionFactoryBuilder)connectionFactoryBuilder, (int)poolSize), defaultConfiguration, initialCacheConfigs);
        this.internalClient = true;
    }

    protected Collection<? extends Cache> loadCaches() {
        ArrayList<Cache> caches = new ArrayList<Cache>(this.initialCacheConfigs.size());
        for (Map.Entry<String, ArcusCacheConfiguration> entry : this.initialCacheConfigs.entrySet()) {
            caches.add(this.createCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected Cache getMissingCache(String name) {
        return this.createCache(name, this.defaultConfiguration);
    }

    protected Cache createCache(String name, ArcusCacheConfiguration configuration) {
        ArcusCache cache = new ArcusCache();
        cache.setName(name);
        cache.setServiceId(configuration.getServiceId());
        cache.setPrefix(configuration.getPrefix());
        cache.setArcusClient(this.client);
        cache.setExpireSeconds(configuration.getExpireSeconds());
        cache.setTimeoutMilliSeconds(configuration.getTimeoutMilliSeconds());
        cache.setOperationTranscoder(configuration.getOperationTranscoder());
        cache.setWantToGetException(true);
        return cache;
    }

    public void destroy() {
        if (this.internalClient) {
            this.client.shutdown();
        }
    }
}

