/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.arcus.spring.concurrent;

import com.navercorp.arcus.spring.concurrent.KeyLockProvider;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultKeyLockProvider
implements KeyLockProvider {
    public static final int DEFAULT_EXPONENT_OF_LOCKS = 11;
    private final ReadWriteLock[] mutexes;

    public DefaultKeyLockProvider() {
        this(11);
    }

    public DefaultKeyLockProvider(int exponentOfLocks) {
        if (exponentOfLocks < 0) {
            exponentOfLocks = 11;
        }
        int numberOfLocks = (int)Math.pow(2.0, exponentOfLocks);
        this.mutexes = new ReadWriteLock[numberOfLocks];
        for (int i = 0; i < numberOfLocks; ++i) {
            this.mutexes[i] = new ReentrantReadWriteLock();
        }
    }

    @Override
    public ReadWriteLock getLockForKey(Object key) {
        return this.mutexes[this.selectLock(key)];
    }

    private int selectLock(Object key) {
        if (key == null) {
            return 0;
        }
        return key.hashCode() & this.mutexes.length - 1;
    }
}

