/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.collection.LruCache;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class MonkeyContextBuilder {
    private LruCache<Property, Arbitrary<?>> arbitrariesByProperty;
    private LruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty;
    private int cacheSize = 2000;
    private int generatorContextSize = 1000;

    public MonkeyContextBuilder arbitrariesByProperty(LruCache<Property, Arbitrary<?>> arbitrariesByProperty) {
        this.arbitrariesByProperty = arbitrariesByProperty;
        return this;
    }

    public MonkeyContextBuilder generatorContextByRootProperty(LruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty) {
        this.generatorContextByRootProperty = generatorContextByRootProperty;
        return this;
    }

    public MonkeyContextBuilder cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public MonkeyContextBuilder generatorContextSize(int generatorContextSize) {
        this.generatorContextSize = generatorContextSize;
        return this;
    }

    public MonkeyContext build() {
        if (this.arbitrariesByProperty == null) {
            this.arbitrariesByProperty = new LruCache(this.cacheSize);
        }
        if (this.generatorContextByRootProperty == null) {
            this.generatorContextByRootProperty = new LruCache(this.generatorContextSize);
        }
        return new MonkeyContext(this.arbitrariesByProperty, this.generatorContextByRootProperty);
    }
}

