/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.property.Property;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.4.3", status=API.Status.EXPERIMENTAL)
public final class MonkeyGeneratorContext {
    private final Map<Property, Set<Object>> uniqueSetsByProperty;

    public MonkeyGeneratorContext(Map<Property, Set<Object>> uniqueSetsByProperty) {
        this.uniqueSetsByProperty = uniqueSetsByProperty;
    }

    public synchronized boolean isUniqueAndCheck(Property property, Object value) {
        boolean unique;
        Set set = this.uniqueSetsByProperty.computeIfAbsent(property, p -> new HashSet());
        boolean bl = unique = !set.contains(value);
        if (unique) {
            set.add(value);
            return true;
        }
        return false;
    }

    public void evictUnique(Property property) {
        if (!this.uniqueSetsByProperty.containsKey(property)) {
            return;
        }
        this.uniqueSetsByProperty.get(property).clear();
    }
}

