/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ChildArbitraryContext;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ArbitraryGeneratorContext {
    private final ArbitraryProperty property;
    private final List<ArbitraryProperty> children;
    @Nullable
    private final ArbitraryGeneratorContext ownerContext;
    private final BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, Arbitrary<?>> resolveArbitrary;
    private final List<MatcherOperator<? extends FixtureCustomizer>> fixtureCustomizers;
    private final MonkeyGeneratorContext monkeyGeneratorContext;
    private final LazyArbitrary<Property> pathProperty = LazyArbitrary.lazy(this::initPathProperty);

    public ArbitraryGeneratorContext(ArbitraryProperty property, List<ArbitraryProperty> children, @Nullable ArbitraryGeneratorContext ownerContext, BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, Arbitrary<?>> resolveArbitrary, List<MatcherOperator<? extends FixtureCustomizer>> fixtureCustomizers, MonkeyGeneratorContext monkeyGeneratorContext) {
        this.property = property;
        this.children = new ArrayList<ArbitraryProperty>(children);
        this.ownerContext = ownerContext;
        this.resolveArbitrary = resolveArbitrary;
        this.fixtureCustomizers = fixtureCustomizers;
        this.monkeyGeneratorContext = monkeyGeneratorContext;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.property;
    }

    public Property getProperty() {
        return this.getArbitraryProperty().getObjectProperty().getProperty();
    }

    public AnnotatedType getAnnotatedType() {
        return this.getProperty().getAnnotatedType();
    }

    public Type getType() {
        return this.getProperty().getType();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return this.getProperty().getAnnotation(annotationClass);
    }

    public List<ArbitraryProperty> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public ChildArbitraryContext getChildrenArbitraryContexts() {
        LinkedHashMap childrenValues = new LinkedHashMap();
        for (ArbitraryProperty child : this.getChildren()) {
            Arbitrary<?> arbitrary = this.resolveArbitrary.apply(this, child);
            childrenValues.put(child, arbitrary);
        }
        ChildArbitraryContext childArbitraryContext = new ChildArbitraryContext(this.property.getObjectProperty().getProperty(), childrenValues);
        this.fixtureCustomizers.stream().filter(it -> it.match(this.property.getObjectProperty().getProperty())).map(MatcherOperator::getOperator).findFirst().ifPresent(customizer -> customizer.customizeProperties(childArbitraryContext));
        return childArbitraryContext;
    }

    @Nullable
    public ArbitraryGeneratorContext getOwnerContext() {
        return this.ownerContext;
    }

    public boolean isRootContext() {
        return this.property.getObjectProperty().isRoot();
    }

    public List<MatcherOperator<? extends FixtureCustomizer>> getFixtureCustomizers() {
        return this.fixtureCustomizers;
    }

    public synchronized boolean isUniqueAndCheck(Property property, Object value) {
        return this.monkeyGeneratorContext.isUniqueAndCheck(property, value);
    }

    public void evictUnique(Property property) {
        this.monkeyGeneratorContext.evictUnique(property);
    }

    public Property getPathProperty() {
        return this.pathProperty.getValue();
    }

    private Property initPathProperty() {
        if (this.ownerContext == null) {
            return this.property.getObjectProperty().getProperty();
        }
        return new CompositeProperty(this.property.getObjectProperty().getProperty(), this.ownerContext.getPathProperty());
    }
}

