/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ChildArbitraryContext {
    private final Property parentProperty;
    private final Map<ArbitraryProperty, Arbitrary<?>> arbitrariesByChildProperty;

    public ChildArbitraryContext(Property parentProperty, Map<ArbitraryProperty, Arbitrary<?>> arbitrariesByChildProperty) {
        this.parentProperty = parentProperty;
        this.arbitrariesByChildProperty = arbitrariesByChildProperty;
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    public void replaceArbitrary(Matcher matcher, Arbitrary<?> arbitrary) {
        for (Map.Entry<ArbitraryProperty, Arbitrary<?>> arbitraryByChildProperty : this.arbitrariesByChildProperty.entrySet()) {
            ArbitraryProperty arbitraryProperty = arbitraryByChildProperty.getKey();
            ObjectProperty objectProperty = arbitraryProperty.getObjectProperty();
            if (!matcher.match(objectProperty.getProperty())) continue;
            this.arbitrariesByChildProperty.put(arbitraryProperty, arbitrary);
        }
    }

    public void removeArbitrary(Matcher matcher) {
        this.arbitrariesByChildProperty.entrySet().removeIf(it -> matcher.match(((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty()));
    }

    public Map<String, Arbitrary<?>> getArbitrariesByResolvedName() {
        return this.arbitrariesByChildProperty.entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getResolvedPropertyName(), Map.Entry::getValue));
    }

    public Map<String, Arbitrary<?>> getArbitrariesByPropertyName() {
        return this.arbitrariesByChildProperty.entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty().getName(), Map.Entry::getValue));
    }

    public List<Arbitrary<?>> getArbitraries() {
        return new ArrayList(this.arbitrariesByChildProperty.values());
    }
}

