/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ObjectProperty {
    private final Property property;
    private final PropertyNameResolver propertyNameResolver;
    private final double nullInject;
    @Nullable
    private final Integer elementIndex;
    private final List<Property> childProperties;

    public ObjectProperty(Property property, PropertyNameResolver propertyNameResolver, double nullInject, @Nullable Integer elementIndex, List<Property> childProperties) {
        this.property = property;
        this.propertyNameResolver = propertyNameResolver;
        this.nullInject = nullInject;
        this.elementIndex = elementIndex;
        this.childProperties = childProperties;
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyNameResolver getPropertyNameResolver() {
        return this.propertyNameResolver;
    }

    public String getResolvedPropertyName() {
        return this.getPropertyNameResolver().resolve(this.property);
    }

    public double getNullInject() {
        return this.nullInject;
    }

    @Nullable
    public Integer getElementIndex() {
        return this.elementIndex;
    }

    public List<Property> getChildProperties() {
        return Collections.unmodifiableList(this.childProperties);
    }

    public boolean isRoot() {
        return this.property instanceof RootProperty;
    }

    public ObjectProperty withNullInject(double nullInject) {
        return new ObjectProperty(this.property, this.propertyNameResolver, nullInject, this.elementIndex, this.childProperties);
    }
}

