/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class OptionalContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final OptionalContainerPropertyGenerator INSTANCE = new OptionalContainerPropertyGenerator();
    private static final AnnotatedType INTEGER_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Integer.class);
    private static final AnnotatedType LONG_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Long.class);
    private static final AnnotatedType DOUBLE_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Double.class);
    private static final ArbitraryContainerInfo CONTAINER_INFO = new ArbitraryContainerInfo(0, 1, false);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        AnnotatedType valueAnnotatedType = this.getValueAnnotatedType(property);
        ElementProperty valueProperty = new ElementProperty(property, valueAnnotatedType, 0, 0);
        return new ContainerProperty(Collections.singletonList(valueProperty), CONTAINER_INFO);
    }

    private AnnotatedType getValueAnnotatedType(Property optionalProperty) {
        Class<?> type = Types.getActualType(optionalProperty.getType());
        if (type == OptionalInt.class) {
            return INTEGER_TYPE;
        }
        if (type == OptionalLong.class) {
            return LONG_TYPE;
        }
        if (type == OptionalDouble.class) {
            return DOUBLE_TYPE;
        }
        if (type != Optional.class) {
            throw new IllegalArgumentException("type is not Optional type. propertyType: " + type);
        }
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(optionalProperty.getAnnotatedType());
        if (genericsTypes.size() != 1) {
            throw new IllegalArgumentException("Optional genericTypes must be have 1 generics type for value. propertyType: " + optionalProperty.getType() + ", genericsTypes: " + genericsTypes);
        }
        return genericsTypes.get(0);
    }
}

