/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class StreamContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final StreamContainerPropertyGenerator INSTANCE = new StreamContainerPropertyGenerator();
    private static final AnnotatedType INTEGER_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Integer.class);
    private static final AnnotatedType LONG_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Long.class);
    private static final AnnotatedType DOUBLE_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Double.class);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        AnnotatedType elementAnnotatedType = this.getElementAnnotatedType(property);
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        if (containerInfo == null) {
            containerInfo = context.getGenerateOptions().getArbitraryContainerInfoGenerator(property).generate(context);
        }
        int size = containerInfo.getRandomSize();
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new ElementProperty(property, elementAnnotatedType, sequence, sequence));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }

    private AnnotatedType getElementAnnotatedType(Property streamProperty) {
        Class<?> type = Types.getActualType(streamProperty.getType());
        if (IntStream.class.isAssignableFrom(type)) {
            return INTEGER_TYPE;
        }
        if (LongStream.class.isAssignableFrom(type)) {
            return LONG_TYPE;
        }
        if (DoubleStream.class.isAssignableFrom(type)) {
            return DOUBLE_TYPE;
        }
        if (!Stream.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type is not Stream type. propertyType: " + type);
        }
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(streamProperty.getAnnotatedType());
        if (genericsTypes.size() != 1) {
            throw new IllegalArgumentException("Stream genericTypes must be have 1 generics type for value. propertyType: " + streamProperty.getType() + ", genericsTypes: " + genericsTypes);
        }
        return genericsTypes.get(0);
    }
}

