/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class BeanArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final BeanArbitraryIntrospector INSTANCE = new BeanArbitraryIntrospector();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<ArbitraryProperty> childrenProperties = context.getChildren();
        Map<String, Arbitrary<?>> childrenArbitraries = context.getChildrenArbitraryContexts().getArbitrariesByResolvedName();
        Map<String, PropertyDescriptor> propertyDescriptors = PropertyCache.getPropertyDescriptors(type);
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> ReflectionUtils.newInstance((Class)type, (Object[])new Object[0]));
        for (ArbitraryProperty arbitraryProperty : childrenProperties) {
            String resolvePropertyName;
            Arbitrary<?> arbitrary;
            String originPropertyName = arbitraryProperty.getObjectProperty().getProperty().getName();
            PropertyDescriptor propertyDescriptor = propertyDescriptors.get(originPropertyName);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null || (arbitrary = childrenArbitraries.get(resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName())) == null) continue;
            builderCombinator = builderCombinator.use(arbitrary).in((b, v) -> {
                try {
                    if (v != null) {
                        writeMethod.invoke(b, v);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.log.warn((Throwable)e, () -> "set bean property is failed. name: " + writeMethod.getName() + " value: " + v);
                }
                return b;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build());
    }
}

