/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ReflectionUtils;

@API(since="0.4.2", status=API.Status.EXPERIMENTAL)
public final class FactoryMethodArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final FactoryMethodArbitraryIntrospector INSTANCE = new FactoryMethodArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        Map<String, Arbitrary<?>> childrenArbitraries = context.getChildrenArbitraryContexts().getArbitrariesByResolvedName();
        Map<Method, Parameter[]> parametersByFactoryMethods = PropertyCache.getParametersByFactoryMethods(type);
        if (parametersByFactoryMethods.isEmpty()) {
            throw new IllegalArgumentException("factory method does not exist. type " + type.getSimpleName());
        }
        ArrayList<Map.Entry<Method, Parameter[]>> entries = new ArrayList<Map.Entry<Method, Parameter[]>>(parametersByFactoryMethods.entrySet());
        Map.Entry parametersByMethod = (Map.Entry)entries.get(Randoms.nextInt(entries.size()));
        Method factoryMethod = (Method)parametersByMethod.getKey();
        Parameter[] parameters = (Parameter[])parametersByMethod.getValue();
        int parameterSize = parameters.length;
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> new ArrayList(parameterSize));
        for (Parameter parameter : parameters) {
            if (!childrenArbitraries.containsKey(parameter.getName())) {
                throw new IllegalArgumentException("Factory method parameter property does not exist. " + parameter.getName() + " \ncheck out if using FactoryPropertyGenerator.");
            }
            Arbitrary<?> arbitrary = childrenArbitraries.get(parameter.getName());
            builderCombinator = builderCombinator.use(arbitrary).in((list, value) -> {
                list.add(value);
                return list;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(list -> ReflectionUtils.invokeMethod((Method)factoryMethod, null, (Object[])list.toArray())));
    }
}

