/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class JavaTimeArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private final Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector;

    public JavaTimeArbitraryIntrospector() {
        this(new JavaTimeTypeArbitraryGenerator(){}, new JavaTimeArbitraryResolver(){});
    }

    public JavaTimeArbitraryIntrospector(JavaTimeTypeArbitraryGenerator arbitraryGenerator, JavaTimeArbitraryResolver arbitraryResolver) {
        this.introspector = JavaTimeArbitraryIntrospector.introspectors(arbitraryGenerator, arbitraryResolver);
    }

    @Override
    public boolean match(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        return this.introspector.containsKey(actualType);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Class<?> type = Types.getActualType(context.getType());
        return this.introspector.getOrDefault(type, ctx -> ArbitraryIntrospectorResult.EMPTY).apply(context);
    }

    private static Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspectors(JavaTimeTypeArbitraryGenerator arbitraryGenerator, JavaTimeArbitraryResolver arbitraryResolver) {
        HashMap<Class<ZoneOffset>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector = new HashMap<Class<ZoneOffset>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>>();
        introspector.put(Calendar.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.calendars(arbitraryGenerator.calendars(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Date.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.dates(arbitraryGenerator.dates(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Instant.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.instants(arbitraryGenerator.instants(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalDate.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.localDates(arbitraryGenerator.localDates(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalDateTime.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.localDateTimes(arbitraryGenerator.localDateTimes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalTime.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.localTimes(arbitraryGenerator.localTimes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(ZonedDateTime.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.zonedDateTimes(arbitraryGenerator.zonedDateTimes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(MonthDay.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.monthDays(arbitraryGenerator.monthDays(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(OffsetDateTime.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.offsetDateTimes(arbitraryGenerator.offsetDateTimes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(OffsetTime.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.offsetTimes(arbitraryGenerator.offsetTimes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Period.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.periods(arbitraryGenerator.periods(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Duration.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.durations(arbitraryGenerator.durations(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Year.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.years(arbitraryGenerator.years(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(YearMonth.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.yearMonths(arbitraryGenerator.yearMonths(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(ZoneOffset.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.zoneOffsets(arbitraryGenerator.zoneOffsets(), (ArbitraryGeneratorContext)ctx)));
        return Collections.unmodifiableMap(introspector);
    }
}

