/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.api.unique.FilteredMonkeyArbitrary;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class MapEntryElementIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final int MAX_TRIES = 10000;

    @Override
    public boolean match(Property property) {
        return property.getClass() == MapEntryElementProperty.class;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<Arbitrary<?>> arbitraries = context.getChildrenArbitraryContexts().getArbitraries();
        if (arbitraries.size() != 2) {
            throw new IllegalArgumentException("Key and Value should be exist for MapEntryElementType.");
        }
        Property mapEntryProperty = ((MapEntryElementProperty)property.getObjectProperty().getProperty()).getMapEntryProperty();
        if (Types.getActualType(mapEntryProperty.getType()) != Map.Entry.class) {
            arbitraries.set(0, (Arbitrary<?>)new FilteredMonkeyArbitrary<Object>(arbitraries.get(0), it -> context.isUniqueAndCheck(context.getOwnerContext().getPathProperty(), it), 10000));
        }
        Arbitrary arbitrary = Builders.withBuilder(MapEntryElementProperty.MapEntryElementType::new).use(arbitraries.get(0)).in((element, key) -> {
            element.setKey(key);
            return element;
        }).use(arbitraries.get(1)).in((element, value) -> {
            element.setValue(value);
            return element;
        }).build();
        return new ArbitraryIntrospectorResult(arbitrary);
    }
}

